/*
 * Decompiled with CFR 0.152.
 */
package jeus.nio;

import java.nio.ByteBuffer;
import jeus.io.impl.nio.util.ByteBufferCreator;
import jeus.nio.ByteBufferWrapper;
import jeus.nio.ByteBufferWrapperFactory;

class JDKByteBufferWrapperFactory
extends ByteBufferWrapperFactory {
    JDKByteBufferWrapperFactory() {
    }

    public ByteBufferWrapper allocate(int capacity) {
        return new JDKByteBufferWrapper(ByteBufferCreator.allocateByteBuffer((boolean)false, (int)capacity));
    }

    public ByteBufferWrapper allocateDirect(int capacity) {
        return new JDKByteBufferWrapper(ByteBufferCreator.allocateByteBuffer((boolean)true, (int)capacity));
    }

    public ByteBufferWrapper wrap(byte[] array, int offset, int length) {
        return new JDKByteBufferWrapper(ByteBuffer.wrap(array, offset, length));
    }

    public ByteBufferWrapper wrapDirect(byte[] array, int offset, int length) {
        ByteBuffer buffer = ByteBufferCreator.allocateByteBuffer((boolean)true, (int)length);
        for (int i = offset; i < offset + length; ++i) {
            buffer.put(array[i]);
        }
        buffer.flip();
        return new JDKByteBufferWrapper(buffer);
    }

    public void free(ByteBufferWrapper buffer) {
        if (buffer == null) {
            return;
        }
        buffer.clear();
        ByteBufferCreator.freeByteBuffer((ByteBuffer)((ByteBuffer)buffer.getSource()));
    }

    public class JDKByteBufferWrapper
    extends ByteBufferWrapper {
        private ByteBuffer buffer;

        public JDKByteBufferWrapper(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        public byte[] _array() {
            return this.buffer.array();
        }

        public int _arrayOffset() {
            return this.buffer.arrayOffset();
        }

        public ByteBufferWrapper asReadOnlyBuffer() {
            return new JDKByteBufferWrapper(this.buffer.asReadOnlyBuffer());
        }

        public ByteBufferWrapper compact() {
            this.buffer.compact();
            return this;
        }

        public int compareTo(Object ob) {
            return this.buffer.compareTo((ByteBuffer)ob);
        }

        public ByteBufferWrapper duplicate() {
            return new JDKByteBufferWrapper(this.buffer.duplicate());
        }

        public boolean equals(Object ob) {
            return this.buffer.equals(ob);
        }

        public byte get() {
            return this.buffer.get();
        }

        public ByteBufferWrapper get(byte[] dst) {
            this.buffer.get(dst);
            return this;
        }

        public ByteBufferWrapper get(byte[] dst, int offset, int length) {
            this.buffer.get(dst, offset, length);
            return this;
        }

        public byte get(int index) {
            return this.buffer.get(index);
        }

        public char getChar() {
            return this.buffer.getChar();
        }

        public char getChar(int index) {
            return this.buffer.getChar(index);
        }

        public double getDouble() {
            return this.buffer.getDouble();
        }

        public double getDouble(int index) {
            return this.buffer.getDouble(index);
        }

        public float getFloat() {
            return this.buffer.getFloat();
        }

        public float getFloat(int index) {
            return this.buffer.getFloat(index);
        }

        public int getInt() {
            return this.buffer.getInt();
        }

        public int getInt(int index) {
            return this.buffer.getInt(index);
        }

        public long getLong() {
            return this.buffer.getLong();
        }

        public long getLong(int index) {
            return this.buffer.getLong(index);
        }

        public short getShort() {
            return this.buffer.getShort();
        }

        public short getShort(int index) {
            return this.buffer.getShort(index);
        }

        public boolean hasArray() {
            return this.buffer.hasArray();
        }

        public int hashCode() {
            return this.buffer.hashCode();
        }

        public boolean isDirect() {
            return this.buffer.isDirect();
        }

        public ByteBufferWrapper put(byte b) {
            this.buffer.put(b);
            return this;
        }

        public ByteBufferWrapper put(int index, byte b) {
            this.buffer.put(index, b);
            return this;
        }

        public ByteBufferWrapper put(byte[] src) {
            this.buffer.put(src);
            return this;
        }

        public ByteBufferWrapper put(byte[] src, int offset, int length) {
            this.buffer.put(src, offset, length);
            return this;
        }

        public ByteBufferWrapper put(ByteBufferWrapper src) {
            this.buffer.put((ByteBuffer)src.getSource());
            return this;
        }

        public ByteBufferWrapper putChar(int index, char value) {
            this.buffer.putChar(index, value);
            return this;
        }

        public ByteBufferWrapper putChar(char value) {
            this.buffer.putChar(value);
            return this;
        }

        public ByteBufferWrapper putDouble(int index, double value) {
            this.buffer.putDouble(index, value);
            return this;
        }

        public ByteBufferWrapper putDouble(double value) {
            this.buffer.putDouble(value);
            return this;
        }

        public ByteBufferWrapper putFloat(int index, float value) {
            this.buffer.putFloat(index, value);
            return this;
        }

        public ByteBufferWrapper putFloat(float value) {
            this.buffer.putFloat(value);
            return this;
        }

        public ByteBufferWrapper putInt(int index, int value) {
            this.buffer.putInt(index, value);
            return this;
        }

        public ByteBufferWrapper putInt(int value) {
            this.buffer.putInt(value);
            return this;
        }

        public ByteBufferWrapper putLong(int index, long value) {
            this.buffer.putLong(index, value);
            return this;
        }

        public ByteBufferWrapper putLong(long value) {
            this.buffer.putLong(value);
            return this;
        }

        public ByteBufferWrapper putShort(int index, short value) {
            this.buffer.putShort(index, value);
            return this;
        }

        public ByteBufferWrapper putShort(short value) {
            this.buffer.putShort(value);
            return this;
        }

        public ByteBufferWrapper slice() {
            return new JDKByteBufferWrapper(this.buffer.slice());
        }

        public String toString() {
            return this.buffer.toString();
        }

        public int capacity() {
            return this.buffer.capacity();
        }

        public ByteBufferWrapper clear() {
            this.buffer.clear();
            return this;
        }

        public ByteBufferWrapper flip() {
            this.buffer.flip();
            return this;
        }

        public boolean hasRemaining() {
            return this.buffer.hasRemaining();
        }

        public boolean isReadOnly() {
            return this.buffer.isReadOnly();
        }

        public int limit() {
            return this.buffer.limit();
        }

        public ByteBufferWrapper limit(int newLimit) {
            this.buffer.limit(newLimit);
            return this;
        }

        public ByteBufferWrapper mark() {
            this.buffer.mark();
            return this;
        }

        public int position() {
            return this.buffer.position();
        }

        public ByteBufferWrapper position(int newPosition) {
            this.buffer.position(newPosition);
            return this;
        }

        public int remaining() {
            return this.buffer.remaining();
        }

        public ByteBufferWrapper reset() {
            this.buffer.reset();
            return this;
        }

        public ByteBufferWrapper rewind() {
            this.buffer.rewind();
            return this;
        }

        public Object getSource() {
            return this.buffer;
        }
    }
}

