/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.components.crypto;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.util.Loader;

public abstract class CryptoFactory {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$ws$security$components$crypto$CryptoFactory == null ? (class$org$apache$ws$security$components$crypto$CryptoFactory = CryptoFactory.class$("org.apache.ws.security.components.crypto.CryptoFactory")) : class$org$apache$ws$security$components$crypto$CryptoFactory));
    private static final String defaultCryptoClassName = "org.apache.ws.security.components.crypto.Merlin";
    static /* synthetic */ Class class$org$apache$ws$security$components$crypto$CryptoFactory;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public static Crypto getInstance() {
        return CryptoFactory.getInstance("crypto.properties");
    }

    public static Crypto getInstance(Properties properties) {
        String cryptoClassName = properties.getProperty("org.apache.ws.security.crypto.provider");
        return CryptoFactory.loadClass(cryptoClassName, properties);
    }

    public static Crypto getInstance(Properties properties, ClassLoader classLoader) {
        String cryptoClassName = properties.getProperty("org.apache.ws.security.crypto.provider");
        return CryptoFactory.loadClass(cryptoClassName, properties, classLoader);
    }

    public static Crypto getInstance(String cryptoClassName, Properties properties) {
        return CryptoFactory.loadClass(cryptoClassName, properties);
    }

    public static Crypto getInstance(String propFilename) {
        Properties properties = null;
        String cryptoClassName = null;
        if (cryptoClassName == null || cryptoClassName.length() == 0) {
            properties = CryptoFactory.getProperties(propFilename);
            cryptoClassName = properties.getProperty("org.apache.ws.security.crypto.provider", defaultCryptoClassName);
        }
        return CryptoFactory.loadClass(cryptoClassName, properties);
    }

    public static Crypto getInstance(String propFilename, ClassLoader customClassLoader) {
        Properties properties = null;
        String cryptoClassName = null;
        if (cryptoClassName == null || cryptoClassName.length() == 0) {
            properties = CryptoFactory.getProperties(propFilename, customClassLoader);
            cryptoClassName = properties.getProperty("org.apache.ws.security.crypto.provider", defaultCryptoClassName);
        }
        return CryptoFactory.loadClass(cryptoClassName, properties, customClassLoader);
    }

    private static Crypto loadClass(String cryptoClassName, Properties properties) {
        return CryptoFactory.loadClass(cryptoClassName, properties, (class$org$apache$ws$security$components$crypto$CryptoFactory == null ? (class$org$apache$ws$security$components$crypto$CryptoFactory = CryptoFactory.class$("org.apache.ws.security.components.crypto.CryptoFactory")) : class$org$apache$ws$security$components$crypto$CryptoFactory).getClassLoader());
    }

    private static Crypto loadClass(String cryptoClassName, Properties properties, ClassLoader loader) {
        Class cryptogenClass = null;
        Crypto crypto = null;
        try {
            cryptogenClass = Loader.loadClass(loader, cryptoClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(cryptoClassName + " Not Found");
        }
        log.debug((Object)("Using Crypto Engine [" + cryptoClassName + "]"));
        try {
            Class[] classes = new Class[]{class$java$util$Properties == null ? (class$java$util$Properties = CryptoFactory.class$("java.util.Properties")) : class$java$util$Properties, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = CryptoFactory.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader};
            Constructor c = cryptogenClass.getConstructor(classes);
            crypto = (Crypto)c.newInstance(properties, loader);
            return crypto;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)("Unable to instantiate (1): " + cryptoClassName), (Throwable)e);
            try {
                crypto = (Crypto)cryptogenClass.newInstance();
                return crypto;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                log.error((Object)("Unable to instantiate (2): " + cryptoClassName), (Throwable)e2);
                throw new RuntimeException(cryptoClassName + " cannot create instance");
            }
        }
    }

    private static Properties getProperties(String propFilename) {
        return CryptoFactory.getProperties(propFilename, (class$org$apache$ws$security$components$crypto$CryptoFactory == null ? (class$org$apache$ws$security$components$crypto$CryptoFactory = CryptoFactory.class$("org.apache.ws.security.components.crypto.CryptoFactory")) : class$org$apache$ws$security$components$crypto$CryptoFactory).getClassLoader());
    }

    private static Properties getProperties(String propFilename, ClassLoader loader) {
        Properties properties = new Properties();
        try {
            URL url = Loader.getResource(loader, propFilename);
            properties.load(url.openStream());
        }
        catch (Exception e) {
            log.debug((Object)("Cannot find crypto property file: " + propFilename));
            throw new RuntimeException("CryptoFactory: Cannot load properties: " + propFilename);
        }
        return properties;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

