/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.archivist;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipOutputStream;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.AbstractArchiveFactory;
import jeus.deploy.archivist.ArchiveHelper;
import jeus.deploy.archivist.InputJarArchive;
import jeus.deploy.archivist.OutputJarArchive;
import jeus.util.file.FileUtils;

public class JarArchiveFactory
implements AbstractArchiveFactory {
    public AbstractArchive createArchive(String path) throws IOException {
        OutputJarArchive ja = new OutputJarArchive();
        ja.create(path);
        return ja;
    }

    public static AbstractArchive createArchiveStatic(String path) throws IOException {
        OutputJarArchive ja = new OutputJarArchive();
        ja.create(path);
        return ja;
    }

    public AbstractArchive openArchive(String path) throws IOException {
        InputJarArchive ja = new InputJarArchive();
        ja.open(path);
        return ja;
    }

    public static AbstractArchive openArchiveStatic(String path) throws IOException {
        InputJarArchive ja = new InputJarArchive();
        ja.open(path);
        return ja;
    }

    public static AbstractArchive openArchiveStatic(File path) throws IOException {
        InputJarArchive ja = new InputJarArchive();
        ja.open(path);
        return ja;
    }

    public static ArrayList openArchivesStatic(String path) throws IOException {
        File pathDirectory = new File(path);
        String[] files = pathDirectory.list();
        ArrayList<AbstractArchive> archives = new ArrayList<AbstractArchive>();
        for (int i = 0; i < files.length; ++i) {
            String file = files[i];
            if (FileUtils.isExploded(file) || !file.endsWith("ear")) continue;
            archives.add(JarArchiveFactory.openArchiveStatic(path + File.separator + file));
        }
        return archives;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputJarArchive appendJarArchive(InputJarArchive archive, String entryName) throws IOException {
        String fileName = archive.getArchiveUri();
        String tempFileName = fileName + ".tmp";
        archive.renameTo(fileName + ".tmp");
        archive = (InputJarArchive)JarArchiveFactory.openArchiveStatic(tempFileName);
        try {
            OutputJarArchive outJar = (OutputJarArchive)JarArchiveFactory.createArchiveStatic(fileName);
            Enumeration enum1 = archive.entries();
            while (enum1.hasMoreElements()) {
                String entry = (String)enum1.nextElement();
                if (entry.equals(entryName)) continue;
                InputStream is = archive.getEntry(entry);
                ZipOutputStream os = (ZipOutputStream)outJar.addEntry(entry);
                ArchiveHelper.copyWithoutClose(is, os);
                is.close();
                os.closeEntry();
            }
            OutputJarArchive outputJarArchive = outJar;
            return outputJarArchive;
        }
        finally {
            archive.delete();
        }
    }
}

