/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.archivist;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import jeus.deploy.archivist.InputJarArchive;
import jeus.deploy.archivist.JarArchiveFactory;

public class JarEntryInputStream
extends InputStream {
    private InputStream entryIs;
    private InputJarArchive archive;

    public JarEntryInputStream(File input, String jarName) throws IOException {
        this.archive = (InputJarArchive)JarArchiveFactory.openArchiveStatic(input);
        this.entryIs = this.archive.getEntry(jarName);
        if (this.entryIs == null) {
            this.archive.close();
            String uri = this.archive.getArchiveUri();
            this.archive = null;
            throw new IOException("there is no entry " + jarName + " in the archive " + uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.entryIs.close();
        }
        finally {
            this.archive.close();
        }
    }

    public int read() throws IOException {
        try {
            return this.entryIs.read();
        }
        catch (IOException ex) {
            this.archive.close();
            throw ex;
        }
    }

    public int read(byte[] b) throws IOException {
        try {
            return this.entryIs.read(b);
        }
        catch (IOException ex) {
            this.archive.close();
            throw ex;
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            return this.entryIs.read(b, off, len);
        }
        catch (IOException ex) {
            this.archive.close();
            throw ex;
        }
    }

    public long skip(long n) throws IOException {
        try {
            return this.entryIs.skip(n);
        }
        catch (IOException ex) {
            this.archive.close();
            throw ex;
        }
    }

    public int available() throws IOException {
        try {
            return this.entryIs.available();
        }
        catch (IOException ex) {
            this.archive.close();
            throw ex;
        }
    }

    public synchronized void mark(int readlimit) {
        this.entryIs.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        try {
            this.entryIs.reset();
        }
        catch (IOException ex) {
            this.archive.close();
            throw ex;
        }
    }

    public boolean markSupported() {
        return this.entryIs.markSupported();
    }

    public int hashCode() {
        return this.entryIs.hashCode();
    }

    public boolean equals(Object obj) {
        return this.entryIs.equals(obj);
    }

    public String toString() {
        return this.entryIs.toString();
    }
}

