/*
 * Decompiled with CFR 0.152.
 */
package jeus.io;

import java.io.IOException;
import java.net.Socket;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jeus.io.AcceptorListener;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Network;
import jeus.util.properties.JeusNetProperties;

public abstract class Acceptor
implements Runnable {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.io");
    private volatile boolean running = true;
    private final Object lock = new Object();
    protected int realListenPort;
    private final Set listeners = new HashSet();
    protected int failCount;

    protected boolean acceptFailed(IOException e) {
        try {
            if (this.isRunning() && logger.isLoggable(JeusMessage_Network._6_LEVEL)) {
                logger.log(JeusMessage_Network._6_LEVEL, JeusMessage_Network._6, this, (Throwable)e);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ++this.failCount;
        if (this.failCount >= JeusNetProperties.ACCEPT_FAIL_LIMIT) {
            this.stop();
            this.fireAcceptFailed(e);
            return false;
        }
        return true;
    }

    protected void acceptSucceed() {
        this.failCount = 0;
    }

    public synchronized void registerListener(AcceptorListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void unregisterListener(AcceptorListener listener) {
        this.listeners.remove(listener);
    }

    protected final synchronized void fireAcceptStarted() {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((AcceptorListener)i.next()).acceptStarted();
        }
    }

    protected final synchronized void fireAcceptFailed(IOException e) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((AcceptorListener)i.next()).acceptFailed(e);
        }
    }

    protected final synchronized void fireAcceptStopped() {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((AcceptorListener)i.next()).acceptStopped();
        }
    }

    public final Socket accept() throws IOException {
        throw new UnsupportedOperationException("accept");
    }

    public int getRealListenPort() {
        return this.realListenPort;
    }

    public abstract int getServerSocketPort();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.running) {
                return;
            }
            this.running = false;
        }
        this.destroyInternal();
    }

    protected abstract void destroyInternal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isRunning() {
        Object object = this.lock;
        synchronized (object) {
            return this.running;
        }
    }
}

