/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.helper;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import jeus.io.Acceptor;
import jeus.io.Connector;
import jeus.io.Selector;
import jeus.io.SocketListener;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.handler.StreamContentReceiver;
import jeus.io.helper.DualSelectorWrapper;
import jeus.io.helper.MultiSelectorWrapper;
import jeus.io.helper.OnePortBlockingConnector;
import jeus.io.helper.OnePortBlockingConnector13;
import jeus.io.helper.OnePortChannelConnector;
import jeus.io.impl.StreamHandlerImpl;
import jeus.io.impl.blocking.BlockingSelector;
import jeus.io.impl.blocking.SSLSocketAcceptor;
import jeus.io.impl.blocking.SSLSocketAcceptor13;
import jeus.io.impl.blocking.SSLSocketConnector;
import jeus.io.impl.blocking.SSLSocketConnector13;
import jeus.io.impl.blocking.SocketAcceptor;
import jeus.io.impl.blocking.SocketAcceptor13;
import jeus.io.impl.blocking.SocketConnector;
import jeus.io.impl.blocking.SocketConnector13;
import jeus.io.impl.blocking.handler.BlockingStreamHandlerImpl;
import jeus.io.impl.blocking.handler.BlockingStreamHandlerImpl14;
import jeus.io.impl.blockingChannel.handler.BlockingChannelStreamHandlerImpl;
import jeus.io.impl.local.LocalStreamHandlerImpl;
import jeus.io.impl.local.LocalStreamHandlerImpl14;
import jeus.io.impl.nio.ChannelAcceptor;
import jeus.io.impl.nio.ChannelConnector;
import jeus.io.impl.nio.NIOSelector;
import jeus.io.impl.nio.handler.NIOStreamHandlerImpl;
import jeus.io.protocol.message.ContentHandlerCreator;
import jeus.io.protocol.message.ssl.SSLConfiguration;
import jeus.io.protocol.message.ssl.SSLContentBufferWrapper;
import jeus.io.protocol.message.ssl.SSLContentWriterWrapper;
import jeus.util.DaemonThreadFactory;
import jeus.util.JeusBootstrapPropertyValues;
import jeus.util.PooledExecutorFactory;
import jeus.util.concurrent50.concurrent.Executor;
import jeus.util.concurrent50.concurrent.ExecutorService;
import jeus.util.concurrent50.concurrent.Executors;
import jeus.util.net.SocketDispatcher;
import jeus.util.properties.JeusNetProperties;

public class IOComponentCreator {
    public static final int NIO_SELECTOR = 1;
    public static final int BLOCKING_SOCKET_SELECTOR = 2;
    public static final int BLOCKING_CHANNEL_SELECTOR = 3;
    public static final int LOCAL_SELECTOR = 4;
    private Executor readExecutor;
    public int writeLimit = JeusNetProperties.WRITE_LIMIT;
    public int writeRestart = JeusNetProperties.WRITE_RESTART;
    private int writeRepeat = JeusNetProperties.WRITE_REPEAT_COUNT;
    protected int selectorType;
    public String creatorName;
    private SocketDispatcher socketDispatcher;
    private boolean useDaemonForBlocking = true;

    public IOComponentCreator(int selectorType, String creatorName, int expectedMaxClient) {
        this.selectorType = selectorType;
        this.creatorName = creatorName;
    }

    public IOComponentCreator(int selectorType, String creatorName, boolean useDaemonForBlocking) {
        this.selectorType = selectorType;
        this.creatorName = creatorName;
        this.useDaemonForBlocking = useDaemonForBlocking;
    }

    public IOComponentCreator(int selectorType, String creatorName, int writeLimit, int writeRestart, int writeRepeat) {
        this(selectorType, creatorName, true);
        this.writeLimit = writeLimit;
        this.writeRestart = writeRestart;
        this.writeRepeat = writeRepeat;
    }

    public IOComponentCreator(int selectorType, String creatorName, int expectedMaxClient, int writeLimit, int writeRestart, int writeRepeat) {
        this(selectorType, creatorName, true);
        this.writeLimit = writeLimit;
        this.writeRestart = writeRestart;
        this.writeRepeat = writeRepeat;
    }

    private void initReadPool() {
        if (this.readExecutor == null) {
            this.readExecutor = Executors.newCachedThreadPool(new DaemonThreadFactory(this.creatorName, this.useDaemonForBlocking));
        }
    }

    public static IOComponentCreator createBlockingCreatorWithReadPool(String name, Executor executor, int blokingType) {
        IOComponentCreator creator = new IOComponentCreator(blokingType, name, true);
        creator.readExecutor = executor;
        return creator;
    }

    public static IOComponentCreator createBlockingCreator(String name, int blokingType, int expectedConnectionNumber) {
        return IOComponentCreator.createBlockingCreator(name, blokingType, true);
    }

    public static IOComponentCreator createBlockingCreator(String name, int blokingType, boolean useDaemonForBlocking) {
        ExecutorService executor = Executors.newCachedThreadPool(new DaemonThreadFactory(name, useDaemonForBlocking));
        return IOComponentCreator.createBlockingCreatorWithReadPool(name, executor, blokingType);
    }

    public Selector createSelector(String name, int selectNum, boolean useDualSelector) {
        if (name == null) {
            name = this.creatorName + "-Selector";
        }
        if (this.selectorType == 2 || this.selectorType == 3) {
            return new BlockingSelector();
        }
        if (selectNum > 1) {
            return new MultiSelectorWrapper(name, selectNum, useDualSelector);
        }
        return useDualSelector ? new DualSelectorWrapper(name) : NIOSelector.open(name, true);
    }

    public StreamHandlerImpl createStreamHandler(Object socket, StreamContentReceiver myObjectReceiver) throws IOException {
        return this.createStreamHandler(socket, myObjectReceiver, new ContentHandlerCreator(), this.writeLimit, this.writeRestart, this.writeRepeat, null, Collections.EMPTY_MAP);
    }

    public StreamHandlerImpl createStreamHandler(Object socket, StreamContentReceiver myObjectReceiver, StreamContentHandlerCreator handlerCreator) throws IOException {
        return this.createStreamHandler(socket, myObjectReceiver, handlerCreator, this.writeLimit, this.writeRestart, this.writeRepeat, null, Collections.EMPTY_MAP);
    }

    public StreamHandlerImpl createStreamHandler(Object socket, StreamContentReceiver myObjectReceiver, Object sslContext, Map sslProperties) throws IOException {
        return this.createStreamHandler(socket, myObjectReceiver, new ContentHandlerCreator(), this.writeLimit, this.writeRestart, this.writeRepeat, sslContext, sslProperties);
    }

    public StreamHandlerImpl createStreamHandler(Object socket, StreamContentReceiver myObjectReceiver, StreamContentHandlerCreator handlerCreator, Object sslContext, Map sslProperties) throws IOException {
        return this.createStreamHandler(socket, myObjectReceiver, handlerCreator, this.writeLimit, this.writeRestart, this.writeRepeat, sslContext, sslProperties);
    }

    public StreamHandlerImpl createStreamHandler(Object socket, StreamContentReceiver myObjectReceiver, ClassLoader loader, Object sslContext, Map sslProperties) throws IOException {
        return this.createStreamHandler(socket, myObjectReceiver, new ContentHandlerCreator(loader), this.writeLimit, this.writeRestart, this.writeRepeat, sslContext, sslProperties);
    }

    public StreamHandlerImpl createStreamHandler(Object socket, StreamContentReceiver myObjectReceiver, ClassLoader loader, int writeLimitBytes, int writeRestartBytes, int writeRepeat, Object sslContext, Map sslProperties) throws IOException {
        return this.createStreamHandler(socket, myObjectReceiver, new ContentHandlerCreator(loader), this.writeLimit, this.writeRestart, writeRepeat, sslContext, sslProperties);
    }

    public StreamHandlerImpl createStreamHandler(Object socket, StreamContentReceiver myObjectReceiver, StreamContentHandlerCreator creator, int writeLimitBytes, int writeRestartBytes, int writeRepeat, Object sslContext, Map sslProperties) throws IOException {
        if (this.selectorType == 2 || this.selectorType == 3) {
            this.initReadPool();
        }
        return this.createStreamHandler(socket, myObjectReceiver, creator, this.readExecutor, writeLimitBytes, writeRestartBytes, writeRepeat, sslContext, sslProperties);
    }

    public StreamHandlerImpl createBlockingStreamHandler(Socket socket, StreamContentReceiver myObjectReceiver, int blockingType) throws IOException {
        return this.createBlockingStreamHandler(socket, myObjectReceiver, this.readExecutor, blockingType);
    }

    public StreamHandlerImpl createBlockingStreamHandler(Socket socket, StreamContentReceiver myObjectReceiver, Executor readExecutor, int blockingType) throws IOException {
        return this.createBlockingStreamHandler(socket, myObjectReceiver, new ContentHandlerCreator(), readExecutor, blockingType);
    }

    public StreamHandlerImpl createBlockingStreamHandler(Socket socket, StreamContentReceiver myObjectReceiver, StreamContentHandlerCreator creator, Executor readExecutor, int blockingType) throws IOException {
        StreamHandlerImpl handler = blockingType == 2 ? new BlockingStreamHandlerImpl(myObjectReceiver, creator, readExecutor) : new BlockingChannelStreamHandlerImpl(myObjectReceiver, creator, readExecutor);
        handler.setSocket(socket);
        return handler;
    }

    public StreamHandlerImpl createBlockingStreamHandlerNoThreadPool(Socket socket, StreamContentReceiver myObjectReceiver, int blockingType) throws IOException {
        ContentHandlerCreator handlerCreator = new ContentHandlerCreator();
        Executor executor = PooledExecutorFactory.createPooledExecutor(this.creatorName, Integer.MAX_VALUE);
        StreamHandlerImpl handler = blockingType == 2 ? new BlockingStreamHandlerImpl(myObjectReceiver, handlerCreator, executor) : new BlockingChannelStreamHandlerImpl(myObjectReceiver, handlerCreator, executor);
        handler.setSocket(socket);
        return handler;
    }

    public StreamHandlerImpl createStreamHandler(Object stream, StreamContentReceiver myObjectReceiver, StreamContentHandlerCreator creator, Executor readExecutor, int writeLimitBytes, int writeRestartBytes, int writeRepeat, Object sslContext, Map sslProperties) throws IOException {
        StreamHandlerImpl handler;
        if (stream instanceof Socket) {
            Socket socket = (Socket)stream;
            if (this.selectorType == 2) {
                handler = !JeusBootstrapPropertyValues.isUpperJDK4() ? new BlockingStreamHandlerImpl(myObjectReceiver, creator, readExecutor) : new BlockingStreamHandlerImpl14(myObjectReceiver, creator, readExecutor);
            } else {
                IOComponentCreator.setSSLInfo((SSLContext)sslContext, sslProperties, creator);
                if (this.selectorType == 1) {
                    handler = new NIOStreamHandlerImpl(myObjectReceiver, creator, writeLimitBytes, writeRestartBytes, writeRepeat);
                } else if (this.selectorType == 3) {
                    handler = new BlockingChannelStreamHandlerImpl(myObjectReceiver, creator, readExecutor);
                } else {
                    throw new RuntimeException();
                }
            }
            handler.setSocket(socket);
        } else {
            handler = !JeusBootstrapPropertyValues.isUpperJDK4() ? new LocalStreamHandlerImpl(myObjectReceiver, creator, stream) : new LocalStreamHandlerImpl14(myObjectReceiver, creator, stream);
        }
        return handler;
    }

    public static void setSSLInfo(SSLContext sslContext, Map sslProperties, StreamContentHandlerCreator creator) {
        if (sslContext != null) {
            SSLEngine sslEngine = sslContext.createSSLEngine();
            SSLConfiguration.setSSLProperties(sslEngine, sslProperties, SSLConfiguration.engineSetMethodNames, SSLConfiguration.engineSetMethods);
            creator.setStreamContentBufferWrapper(new SSLContentBufferWrapper(sslEngine));
            creator.setStreamContentWriterWrapper(new SSLContentWriterWrapper(sslEngine));
        }
    }

    public static SSLEngine setSSLInfoToWriter(SSLContext sslContext, Map sslProperties, StreamContentHandlerCreator creator) {
        if (sslContext != null) {
            SSLEngine sslEngine = sslContext.createSSLEngine();
            SSLConfiguration.setSSLProperties(sslEngine, sslProperties, SSLConfiguration.engineSetMethodNames, SSLConfiguration.engineSetMethods);
            creator.setStreamContentWriterWrapper(new SSLContentWriterWrapper(sslEngine));
            return sslEngine;
        }
        return null;
    }

    public Acceptor createAcceptor(int port, SocketListener listener, Object sslContext, int backlog, InetAddress listenHost, String reuseAddress) throws IOException {
        switch (this.selectorType) {
            case 1: 
            case 3: {
                return new ChannelAcceptor(port, listener, backlog, listenHost, reuseAddress);
            }
            case 2: {
                if (!JeusBootstrapPropertyValues.isUpperJDK4()) {
                    if (sslContext != null) {
                        return new SSLSocketAcceptor13(sslContext, port, listener, backlog, listenHost);
                    }
                    return new SocketAcceptor13(port, listener, backlog, listenHost);
                }
                if (sslContext != null) {
                    return new SSLSocketAcceptor(sslContext, port, listener, backlog, listenHost, reuseAddress);
                }
                return new SocketAcceptor(port, listener, backlog, listenHost, reuseAddress);
            }
        }
        throw new RuntimeException();
    }

    public Connector createConnector(Object sslContext, Map sslProperties) {
        switch (this.selectorType) {
            case 1: 
            case 3: {
                return new ChannelConnector();
            }
            case 2: {
                if (sslContext != null) {
                    if (!JeusBootstrapPropertyValues.isUpperJDK4()) {
                        return new SSLSocketConnector13(sslContext, sslProperties);
                    }
                    return new SSLSocketConnector(sslContext, sslProperties);
                }
                if (!JeusBootstrapPropertyValues.isUpperJDK4()) {
                    return new SocketConnector13();
                }
                return new SocketConnector();
            }
        }
        throw new RuntimeException();
    }

    public Connector createOnePortConnector(Object sslContext) {
        switch (this.selectorType) {
            case 1: 
            case 3: {
                return new OnePortChannelConnector();
            }
            case 2: {
                if (!JeusBootstrapPropertyValues.isUpperJDK4()) {
                    return new OnePortBlockingConnector13(sslContext);
                }
                return new OnePortBlockingConnector(sslContext);
            }
        }
        throw new RuntimeException();
    }

    public SocketDispatcher getSocketDispatcher() {
        return this.socketDispatcher;
    }

    public void setSocketDispatcher(SocketDispatcher socketDispatcher) {
        this.socketDispatcher = socketDispatcher;
    }

    public int getCreatorType() {
        return this.selectorType;
    }
}

