/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.helper;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import jeus.io.Connector;
import jeus.util.cnet.SocketProxy;

public class OnePortBlockingConnector
extends Connector {
    private SSLContext sslContext;

    public OnePortBlockingConnector(Object sslContext) {
        this.sslContext = (SSLContext)sslContext;
    }

    public Socket connect(String host, int port, String localHost, int localPort, String id, int connectTimeout, int readTimeout) throws IOException {
        Socket socket;
        if (this.sslContext != null) {
            socket = this.sslContext.getSocketFactory().createSocket();
            if (localHost != null && localPort > 0) {
                socket.bind(new InetSocketAddress(localHost, localPort));
            } else if (localHost == null && localPort > 0) {
                socket.bind(new InetSocketAddress(localPort));
            }
            socket.connect(new InetSocketAddress(host, port), connectTimeout);
        } else {
            socket = SocketProxy.getConnection(host, port, localHost, localPort, id, connectTimeout, false, readTimeout);
        }
        socket.setSoTimeout(readTimeout);
        return socket;
    }
}

