/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.impl.blockingChannel.handler;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.handler.StreamContentReceiver;
import jeus.io.impl.blocking.handler.BlockingStreamHandlerImpl14;
import jeus.io.impl.nio.util.ByteBufferCreator;
import jeus.util.concurrent50.concurrent.Executor;

public class BlockingChannelStreamHandlerImpl
extends BlockingStreamHandlerImpl14 {
    private SocketChannel channel;

    public BlockingChannelStreamHandlerImpl(StreamContentReceiver myObjectReceiver, StreamContentHandlerCreator creator, Executor executor) {
        super(myObjectReceiver, creator, executor);
    }

    public void setSocket(Socket socket) throws IOException {
        this.channel = socket.getChannel();
        super.setSocket(socket);
    }

    protected int getSelectorType() {
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeInternal(Object[] buffer) throws IOException {
        ByteBuffer[] buffers = (ByteBuffer[])buffer;
        ByteBuffer lastBuffer = buffers[buffers.length - 1];
        SocketChannel socketChannel = this.channel;
        synchronized (socketChannel) {
            do {
                if (buffers.length == 1) {
                    this.channel.write(lastBuffer);
                    continue;
                }
                this.channel.write(buffers);
            } while (lastBuffer.hasRemaining());
            for (int j = 0; j < buffers.length; ++j) {
                ByteBuffer byteBuffer = buffers[j];
                ByteBufferCreator.freeByteBuffer(byteBuffer);
            }
        }
        return true;
    }

    public Object getWriteLock() {
        return this.channel;
    }
}

