/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.impl.nio.handler;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import jeus.io.Selector;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.handler.StreamContentReceiver;
import jeus.io.impl.StreamHandlerImpl14;
import jeus.io.impl.nio.NIOSelector;
import jeus.io.impl.nio.util.ByteBufferCreator;
import jeus.util.message.JeusMessage_Network;
import jeus.util.properties.JeusNetProperties;

public class NIOStreamHandlerImpl
extends StreamHandlerImpl14 {
    private static final int WRITE_BLOCK_STATE = 4;
    private SocketChannel channel;
    private SelectionKey selItem;
    private ThreadGroup selectorThreadGroup;
    private final Object eventLock = new Object();
    private int eventOps;
    private final LinkedList waitingListToBeWritten = new LinkedList();
    private final Object writeBlocker = new Object();
    private int totalBytes;
    private int writeRestart;
    private int writeLimit;
    private int writeRepeat;
    private long writeFailTime;
    private static final int NOT_REGISTERED = 0;
    private static final int REGISTER = 1;
    private static final int UPDATE = 2;
    private static final int REGISTER_AND_UPDATE = 3;
    private static final int CANCEL = 4;
    private int actionState = 0;
    private static final String NIO_KEY_CANCELLED = "NIO_KEY_CANCELLED";

    public NIOStreamHandlerImpl(StreamContentReceiver listener, StreamContentHandlerCreator creator, int writeLimit, int writeRestart, int writeRepeat) {
        super(listener, creator);
        if (logger.isLoggable(JeusMessage_Network._107_LEVEL)) {
            logger.log(JeusMessage_Network._107_LEVEL, JeusMessage_Network._107, new Object[]{this, "OP_READ"});
        }
        this.eventOps = 1;
        this.writeRestart = writeRestart;
        this.writeLimit = writeLimit;
        this.writeRepeat = writeRepeat;
    }

    public void waked(int readyEvents) throws IOException {
        int prevEventOps = this.getInterestEvents();
        if (this.isWritable(readyEvents) && this.isWritable(prevEventOps)) {
            this.writeBuffers();
        }
        if (this.isReadable(readyEvents) && this.isReadable(prevEventOps)) {
            this.readContent();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readContent() {
        while (true) {
            if (logger.isLoggable(JeusMessage_Network._111_LEVEL)) {
                logger.log(JeusMessage_Network._111_LEVEL, JeusMessage_Network._111, (Object)this);
            }
            try {
                Object obj = this.readMessage();
                if (obj == null) {
                    if (!logger.isLoggable(JeusMessage_Network._112_LEVEL)) return;
                    logger.log(JeusMessage_Network._112_LEVEL, JeusMessage_Network._112, (Object)this);
                    return;
                }
                this.dispatchMessage(obj);
            }
            catch (Exception ex) {
                if (logger.isLoggable(JeusMessage_Network._128_LEVEL)) {
                    logger.log(JeusMessage_Network._128_LEVEL, JeusMessage_Network._128, (Object)this);
                }
                this.reportException(ex);
                return;
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected void writeBuffers() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeInternal(Object[] buffer) throws IOException {
        block22: {
            boolean needBlock = false;
            try {
                Object object = this.waitingListToBeWritten;
                synchronized (object) {
                    if (this.waitingListToBeWritten.isEmpty()) {
                        if (logger.isLoggable(JeusMessage_Network._119_LEVEL)) {
                            logger.log(JeusMessage_Network._119_LEVEL, JeusMessage_Network._119, (Object)this);
                        }
                        if (this.writeResults(buffer, false)) {
                            if (logger.isLoggable(JeusMessage_Network._120_LEVEL)) {
                                logger.log(JeusMessage_Network._120_LEVEL, JeusMessage_Network._120, (Object)this);
                            }
                            return true;
                        }
                        if (logger.isLoggable(JeusMessage_Network._121_LEVEL)) {
                            logger.log(JeusMessage_Network._121_LEVEL, JeusMessage_Network._121, (Object)this);
                        }
                        this.addEventOp(this.getWriteOp());
                    }
                    if (logger.isLoggable(JeusMessage_Network._122_LEVEL)) {
                        logger.log(JeusMessage_Network._122_LEVEL, JeusMessage_Network._122, (Object)this);
                    }
                    this.waitingListToBeWritten.addLast(buffer);
                    this.afterPutWriteBuffer(buffer);
                    if (this.isNotInState(4) && this.writeLimit < this.getTotalBytes()) {
                        if (Thread.currentThread().getThreadGroup() != this.selectorThreadGroup) {
                            needBlock = true;
                        }
                        if (logger.isLoggable(JeusMessage_Network._123_LEVEL)) {
                            logger.log(JeusMessage_Network._123_LEVEL, JeusMessage_Network._123, (Object)this);
                        }
                        this.setState(4);
                    }
                }
                if (!needBlock) break block22;
                object = this.writeBlocker;
                synchronized (object) {
                    try {
                        while (this.isInState(4)) {
                            if (logger.isLoggable(JeusMessage_Network._124_LEVEL)) {
                                logger.log(JeusMessage_Network._124_LEVEL, JeusMessage_Network._124, (Object)this);
                            }
                            this.writeBlocker.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException ex) {
                if (logger.isLoggable(JeusMessage_Network._129_LEVEL)) {
                    logger.log(JeusMessage_Network._129_LEVEL, JeusMessage_Network._129, (Object)this);
                }
                this.close(ex);
                throw ex;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeResults(Object[] buffer, boolean writeThread) throws IOException {
        ByteBuffer[] buffers = (ByteBuffer[])buffer;
        ByteBuffer lastBuffer = buffers[buffers.length - 1];
        int loop = 0;
        int remainingWriterepeatCount = this.writeRepeat;
        while (true) {
            long length;
            if ((length = buffers.length == 1 ? (long)this.channel.write(lastBuffer) : this.channel.write(buffers)) == 0L && lastBuffer.hasRemaining()) {
                if (loop >= JeusNetProperties.USE_BUSY_WRITE_REPEAT) {
                    if (writeThread) {
                        long elapsedTime;
                        if (this.writeFailTime == 0L) {
                            this.writeFailTime = System.currentTimeMillis();
                        }
                        if ((elapsedTime = System.currentTimeMillis() - this.writeFailTime) >= JeusNetProperties.WRITE_FAIL_TIMEOUT) {
                            throw new IOException("failed to write. Sender's tcp write buffer is full, but receiver doesn't read any data for " + this.writeFailTime + "ms");
                        }
                    }
                    return false;
                }
                ++loop;
                continue;
            }
            this.writeFailTime = 0L;
            loop = 0;
            --remainingWriterepeatCount;
            if (writeThread) {
                LinkedList elapsedTime = this.waitingListToBeWritten;
                synchronized (elapsedTime) {
                    this.totalBytes = (int)((long)this.totalBytes - length);
                }
            }
            if (!lastBuffer.hasRemaining()) {
                for (int j = 0; j < buffers.length; ++j) {
                    ByteBuffer byteBuffer = buffers[j];
                    ByteBufferCreator.freeByteBuffer(byteBuffer);
                }
                return true;
            }
            if (this.writeRepeat > 0 && remainingWriterepeatCount <= 0) break;
        }
        return false;
    }

    public Object getWriteLock() {
        return this.waitingListToBeWritten;
    }

    protected int getTotalBytes() {
        return this.totalBytes;
    }

    protected void afterPutWriteBuffer(Object[] toBeWrite) {
        for (int i = 0; i < toBeWrite.length; ++i) {
            this.totalBytes += ((ByteBuffer)toBeWrite[i]).remaining();
        }
    }

    public int getInterestEvents() {
        return this.eventOps;
    }

    public void addEventOp(int addEvent) throws IOException {
        this.addEventOp(addEvent, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventOp(int addEvent, boolean updateSelector) throws IOException {
        Object object = this.eventLock;
        synchronized (object) {
            if (this.isClosed() || addEvent == 0 || (this.eventOps & addEvent) > 0) {
                if (logger.isLoggable(JeusMessage_Network._108_LEVEL)) {
                    logger.log(JeusMessage_Network._108_LEVEL, JeusMessage_Network._108, new Object[]{Integer.toString(addEvent), this});
                }
                return;
            }
            this.eventOps |= addEvent;
            if (this.registered && updateSelector) {
                this.selector.updateSelectItem(this);
            } else if (logger.isLoggable(JeusMessage_Network._109_LEVEL)) {
                logger.log(JeusMessage_Network._109_LEVEL, JeusMessage_Network._109, new Object[]{Integer.toString(addEvent), this});
            }
        }
    }

    public void removeEventOp(int removeEvent) throws IOException {
        this.removeEventOp(removeEvent, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventOp(int removeEvent, boolean updateSelector) throws IOException {
        Object object = this.eventLock;
        synchronized (object) {
            if (this.isClosed() || removeEvent == 0 || (this.eventOps & removeEvent) == 0) {
                return;
            }
            this.eventOps &= ~removeEvent;
            if (this.registered && updateSelector) {
                this.selector.updateSelectItem(this);
            }
        }
    }

    public void close(Exception ex) {
        super.close(ex);
        this.clearWaitingListToBeWritten();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearWaitingListToBeWritten() {
        LinkedList linkedList = this.waitingListToBeWritten;
        synchronized (linkedList) {
            if (logger.isLoggable(JeusMessage_Network._110_LEVEL)) {
                logger.log(JeusMessage_Network._110_LEVEL, JeusMessage_Network._110, (Object)this);
            }
            Object object = this.writeBlocker;
            synchronized (object) {
                if (logger.isLoggable(JeusMessage_Network._117_LEVEL)) {
                    logger.log(JeusMessage_Network._117_LEVEL, JeusMessage_Network._117, (Object)this);
                }
                this.writeBlocker.notifyAll();
                this.unsetState(4);
                this.totalBytes = 0;
            }
        }
    }

    public void setSelector(Selector selector) {
        super.setSelector(selector);
        this.selectorThreadGroup = ((NIOSelector)selector).getThreadGroup();
    }

    public void setSocket(Socket socket) throws IOException {
        this.channel = socket.getChannel();
        super.setSocket(socket);
    }

    protected int getSelectorType() {
        return 1;
    }

    protected int getWriteOp() {
        return 4;
    }

    public boolean isWritable(int readyEvents) {
        return (readyEvents & 4) != 0;
    }

    protected boolean isReadable(int readyEvents) {
        return (readyEvents & 1) != 0;
    }

    public void setSelectItem(SelectionKey item) {
        this.selItem = item;
    }

    public SelectionKey getSelectItem() {
        return this.selItem;
    }

    public boolean isRegisterActionState() {
        return this.actionState == 1 || this.actionState == 3;
    }

    public boolean isUpdateActionState() {
        return this.actionState == 2 || this.actionState == 3;
    }

    public boolean isCancelActionState() {
        return this.actionState == 4;
    }

    public void setRegisterAction() {
        this.actionState = 1;
    }

    public void setUpdateAction() {
        if (this.actionState == 4) {
            return;
        }
        this.actionState = this.actionState == 1 ? 3 : 2;
    }

    public void setCancelAction() {
        this.actionState = 4;
    }

    public void keyCancelCalled() {
        this.contentReader.eventOccurred(NIO_KEY_CANCELLED);
    }
}

