/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.impl.nio.protocol.message;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import jeus.io.impl.nio.util.ByteBufferCreator;
import jeus.io.impl.nio.util.ByteBufferOutputStream;
import jeus.io.protocol.message.ContentWriter;
import jeus.util.ObjectInputStreamWithLoader;

public class NIOContentWriter
extends ContentWriter {
    private ClassLoader classloader;

    public NIOContentWriter() {
    }

    public NIOContentWriter(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public Object[] getBufferToBeWrite(Object toBeWrite, byte[] header) throws IOException {
        ByteBufferOutputStream bbis = new ByteBufferOutputStream(ByteBufferCreator.DEFAULT_BUFFER_SIZE);
        ByteBuffer byteBuffer = bbis.getByteBuffer();
        if (header == null) {
            byteBuffer.put(OBJECT_MAGIC_BYTE);
            byteBuffer.position(8);
        } else {
            byteBuffer.put(OBJECT_HEADER_MAGIC_BYTE);
            byteBuffer.position(8);
            if (header.length == 0) {
                throw new RuntimeException();
            }
            byteBuffer.putInt(header.length);
            byteBuffer.put(header);
        }
        ObjectOutputStream oos = this.makeOutputStream(bbis);
        oos.writeObject(toBeWrite);
        oos.flush();
        byteBuffer = bbis.getByteBuffer();
        byteBuffer.putInt(4, byteBuffer.position() - 8);
        byteBuffer.flip();
        return new ByteBuffer[]{byteBuffer};
    }

    public ObjectOutputStream makeOutputStream(OutputStream bbis) throws IOException {
        return new ObjectOutputStream(bbis);
    }

    public ObjectInputStream makeInputStream(InputStream is) throws IOException {
        return new ObjectInputStreamWithLoader(is, this.classloader);
    }

    public Object[] getBufferToBeWrite(ByteBuffer byteBuffer, byte[] header) throws IOException {
        byteBuffer.flip();
        if (header == null) {
            byteBuffer.put(BYTE_MAGIC_BYTE);
            byteBuffer.putInt(byteBuffer.limit() - 8);
        } else {
            byteBuffer.put(BYTE_HEADER_MAGIC_BYTE);
            byteBuffer.putInt(byteBuffer.limit() - 8);
            if (header.length > 0) {
                byteBuffer.putInt(header.length);
                byteBuffer.put(header);
            }
        }
        byteBuffer.position(0);
        return new ByteBuffer[]{byteBuffer};
    }

    public Object[] getBufferToBeWrite(byte[] bytes, int offset, int length, byte[] header) {
        ByteBufferOutputStream bbis = header == null || header.length == 0 ? new ByteBufferOutputStream(length + 8) : new ByteBufferOutputStream(length + 8 + 4 + header.length);
        ByteBuffer byteBuffer = bbis.getByteBuffer();
        if (header == null) {
            byteBuffer.put(BYTE_MAGIC_BYTE);
            byteBuffer.putInt(length);
        } else {
            byteBuffer.put(BYTE_HEADER_MAGIC_BYTE);
            byteBuffer.putInt(length + header.length + 4);
            if (header.length > 0) {
                byteBuffer.putInt(header.length);
                bbis.write(header);
            }
        }
        bbis.write(bytes, offset, length);
        byteBuffer = bbis.getByteBuffer();
        byteBuffer.flip();
        return new ByteBuffer[]{byteBuffer};
    }
}

