/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.impl.nio.util;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import jeus.io.impl.nio.util.BufferCache;
import jeus.util.ArrayListStack;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Network;
import jeus.util.properties.JeusNetProperties;

public class ByteBufferCreator {
    public static final int DEFAULT_BUFFER_SIZE = JeusNetProperties.TCP_BUFFER_SIZE;
    public static final ByteBuffer dummyBuffer = ByteBuffer.allocate(0);
    public static final ByteBuffer[] dummyBuffers = new ByteBuffer[]{dummyBuffer};
    private static final BufferCache cache = new DirectBufferCache();
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.io");

    public static ByteBuffer allocateByteBuffer(boolean isDirect, int size) {
        return ByteBufferCreator.allocateByteBuffer(isDirect, size, false);
    }

    public static ByteBuffer allocateByteBuffer(boolean isDirect, int size, boolean setLimitToSize) {
        ByteBuffer buffer;
        ByteBuffer byteBuffer = buffer = isDirect ? cache.getDirectBuffer(size) : ByteBuffer.allocate(size);
        if (setLimitToSize) {
            buffer.limit(size);
        }
        return buffer;
    }

    public static void freeByteBuffer(ByteBuffer buffer) {
        if (buffer == null || !buffer.isDirect() || buffer.isReadOnly()) {
            return;
        }
        cache.release(buffer);
    }

    public static int cachedDirectBuffer() {
        return cache.cachedDirectBuffer();
    }

    public static int totalDirectBuffer() {
        return cache.totalDirectBuffer();
    }

    public static int viewBufferCount() {
        return cache.viewBufferCount();
    }

    public static int nonViewBufferCount() {
        return cache.nonViewBufferCount();
    }

    public static void main(String[] args) {
        ByteBuffer buffer = ByteBufferCreator.allocateByteBuffer(true, 32, true);
        System.out.println("***** buffer capacity : " + buffer.capacity() + ", pos : " + buffer.position() + ", limit : " + buffer.limit());
    }

    private static class DirectBufferCache
    implements BufferCache {
        private HashMap directBufferMap = new HashMap();
        private int[] indexer = new int[31];
        private int cached;
        private int total;
        public static int capacity = JeusNetProperties.VIEW_BUFFER_SIZE;
        public static int cacheFlushCapacity = JeusNetProperties.CACHE_FLUSH_BUFFER_SIZE;
        private ByteBuffer byteBuffer;
        private int viewBufferNotUsed;
        private int viewBufferUsed;

        private DirectBufferCache() {
            for (int i = 0; i < this.indexer.length; ++i) {
                this.indexer[i] = 1 << i;
            }
        }

        public synchronized ByteBuffer allocateView(int size) {
            if (this.byteBuffer == null || this.byteBuffer.capacity() - this.byteBuffer.position() < size) {
                if (size < capacity) {
                    this.byteBuffer = this.allocateDirectBuffer(capacity, true);
                } else {
                    return this.allocateDirectBuffer(size, false);
                }
            }
            ++this.viewBufferUsed;
            this.byteBuffer.limit(this.byteBuffer.position() + size);
            ByteBuffer view = this.byteBuffer.slice();
            this.byteBuffer.position(this.byteBuffer.limit());
            return view;
        }

        private synchronized void checkCacheFlush() {
            if (this.total > cacheFlushCapacity) {
                this.clearAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ByteBuffer getDirectBuffer(int size) {
            int index = this.ceilIndex(size);
            int allocateSize = this.indexer[index];
            ArrayListStack bufferList = this.getBufferList(index);
            ByteBuffer buffer = null;
            Object object = bufferList;
            synchronized (object) {
                if (!bufferList.isEmpty()) {
                    buffer = (ByteBuffer)bufferList.pop();
                }
            }
            if (buffer != null) {
                object = this;
                synchronized (object) {
                    this.cached -= buffer.capacity();
                }
                return buffer;
            }
            return this.allocateNew(allocateSize);
        }

        private ByteBuffer allocateNew(int allocateSize) {
            ByteBuffer buffer;
            try {
                buffer = JeusNetProperties.USE_VIEW_BUFFER ? this.allocateView(allocateSize) : this.allocateDirectBuffer(allocateSize, false);
            }
            catch (OutOfMemoryError error) {
                if (logger.isLoggable(JeusMessage_Network._301_LEVEL)) {
                    logger.log(JeusMessage_Network._301_LEVEL, JeusMessage_Network._301, (Throwable)error);
                }
                this.clearAll();
                buffer = ByteBuffer.allocate(allocateSize);
            }
            return buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ByteBuffer allocateDirectBuffer(int allocateSize, boolean viewBuffer) {
            DirectBufferCache directBufferCache = this;
            synchronized (directBufferCache) {
                if (!viewBuffer) {
                    ++this.viewBufferNotUsed;
                }
                this.checkCacheFlush();
                this.total += allocateSize;
            }
            return ByteBuffer.allocateDirect(allocateSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release(ByteBuffer buffer) {
            ArrayListStack bufferList;
            if (logger.isLoggable(JeusMessage_Network._302_LEVEL)) {
                logger.log(JeusMessage_Network._302_LEVEL, JeusMessage_Network._302);
            }
            buffer.clear();
            int index = this.ceilIndex(buffer.capacity());
            ArrayListStack arrayListStack = bufferList = this.getBufferList(index);
            synchronized (arrayListStack) {
                bufferList.push(buffer);
                this.cached += buffer.capacity();
            }
        }

        private int ceilIndex(int size) {
            int index = Arrays.binarySearch(this.indexer, size);
            return index < 0 ? -(index + 1) : index;
        }

        private synchronized ArrayListStack getBufferList(int index) {
            Integer key = new Integer(index);
            ArrayListStack stack = (ArrayListStack)this.directBufferMap.get(key);
            if (stack == null) {
                stack = new ArrayListStack();
                this.directBufferMap.put(key, stack);
            }
            return stack;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void clearAll() {
            Iterator it = this.directBufferMap.values().iterator();
            while (it.hasNext()) {
                ArrayListStack stack = (ArrayListStack)it.next();
                if (stack == null) continue;
                ArrayListStack arrayListStack = stack;
                synchronized (arrayListStack) {
                    stack.clear();
                }
            }
            this.cached = 0;
            this.total = 0;
            this.directBufferMap.clear();
        }

        public int cachedDirectBuffer() {
            return this.cached;
        }

        public int totalDirectBuffer() {
            return this.total;
        }

        public int viewBufferCount() {
            return this.viewBufferUsed;
        }

        public int nonViewBufferCount() {
            return this.viewBufferNotUsed;
        }
    }
}

