/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.impl.nio.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import jeus.io.impl.StreamHandlerImpl;
import jeus.io.impl.nio.util.AdvancedByteBuffer;
import jeus.io.impl.nio.util.ByteBufferCreator;
import jeus.io.impl.nio.util.ByteBufferInputStream;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Network;

public class ChannelInputStreamBuffer {
    protected ReadableByteChannel channel;
    protected AdvancedByteBuffer advancedByteBuffer;
    private ByteBufferInputStream bbis;
    protected StreamHandlerImpl endpoint;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.io");

    public ChannelInputStreamBuffer(StreamHandlerImpl endpoint) {
        this(endpoint, ByteBufferCreator.DEFAULT_BUFFER_SIZE);
    }

    protected ChannelInputStreamBuffer(StreamHandlerImpl endpoint, int size) {
        this.endpoint = endpoint;
        this.channel = endpoint.getSocket().getChannel();
        this.advancedByteBuffer = new AdvancedByteBuffer(size);
        this.bbis = new ByteBufferInputStream();
    }

    public void setReadBufferState() {
        this.advancedByteBuffer.flip();
    }

    public void ensureWhileReadingBuffer(int length) {
        this.advancedByteBuffer.ensureWhileReadingBuffer(length);
    }

    public void get(byte[] payload) {
        this.advancedByteBuffer.get(payload);
    }

    public int read() throws IOException {
        int length = this.readBuffer(this.advancedByteBuffer.getByteBuffer());
        if (length < 0) {
            return -1;
        }
        return this.advancedByteBuffer.position();
    }

    protected int readBuffer(ByteBuffer inBuffer) throws IOException {
        int totalByte = 0;
        if (this.channel == null) {
            this.endpoint.reportException(new IOException("disconnected"));
            return -1;
        }
        do {
            int numBytes;
            if ((numBytes = this.channel.read(inBuffer)) < 0) {
                if (totalByte > 0) {
                    this.channel = null;
                    return totalByte;
                }
                this.endpoint.reportException(new IOException("disconnected"));
                return numBytes;
            }
            if (numBytes == 0) {
                return totalByte;
            }
            totalByte += numBytes;
        } while (inBuffer.hasRemaining());
        return totalByte;
    }

    public int position() {
        return this.advancedByteBuffer.position();
    }

    public int readInt() {
        return this.advancedByteBuffer.getInt();
    }

    public InputStream getInputStream(int appLength) {
        this.bbis.setByteBuffer(this.advancedByteBuffer.getByteBuffer());
        return this.bbis;
    }

    public void close() {
        if (logger.isLoggable(JeusMessage_Network._303_LEVEL)) {
            logger.log(JeusMessage_Network._303_LEVEL, JeusMessage_Network._303, (Object)this.endpoint);
        }
        if (logger.isLoggable(JeusMessage_Network._314_LEVEL)) {
            logger.log(JeusMessage_Network._314_LEVEL, JeusMessage_Network._314);
        }
        if (this.advancedByteBuffer != null) {
            this.advancedByteBuffer.close();
            this.advancedByteBuffer = null;
        }
    }

    public void get(byte[] payload, int bufPosition) {
        this.advancedByteBuffer.get(payload, bufPosition);
    }
}

