/*
 * Decompiled with CFR 0.152.
 */
package jeus.net.helper;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import jeus.net.SocketID;
import jeus.net.SocketStream;
import jeus.net.helper.AbstractReplyListener;
import jeus.net.helper.SequenceContainer;

public class ReplyCollector
extends AbstractReplyListener {
    private final Hashtable sequenceTable = new Hashtable();
    private final HashMap receiveTable = new HashMap();
    private int totalNum;
    private boolean isClosed;

    public ReplyCollector(int totalNum) {
        this.totalNum = totalNum;
    }

    public synchronized void increase() {
        ++this.totalNum;
    }

    public synchronized Map waiting(long timeout) throws IOException {
        if (this.totalNum == 0) {
            return this.receiveTable;
        }
        try {
            this.wait(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.totalNum != 0) {
            this.clear();
            if (this.isClosed) {
                throw new IOException("Connection closed, did not receive all reply : " + this.totalNum);
            }
            throw new IOException("did not receive all reply : " + this.totalNum);
        }
        return this.receiveTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        SequenceContainer[] streamInfos;
        Hashtable hashtable = this.sequenceTable;
        synchronized (hashtable) {
            Collection set = this.sequenceTable.values();
            streamInfos = set.toArray(new SequenceContainer[set.size()]);
        }
        for (int i = 0; i < streamInfos.length; ++i) {
            SequenceContainer streamInfo = streamInfos[i];
            streamInfo.unregisterAllSequences(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSocketStream(SocketStream sockStream, int seq) {
        SequenceContainer list;
        Hashtable hashtable = this.sequenceTable;
        synchronized (hashtable) {
            SocketID socketID = sockStream.getSocketID();
            list = (SequenceContainer)this.sequenceTable.get(socketID);
            if (list == null) {
                list = new SequenceContainer(sockStream);
                this.sequenceTable.put(socketID, list);
            }
        }
        list.addSequence(seq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveMessage(Object obj, SocketStream sockStream, Object controlInfo) {
        Vector<Object> vector;
        SocketID socketID = sockStream.getSocketID();
        HashMap hashMap = this.receiveTable;
        synchronized (hashMap) {
            vector = (Vector<Object>)this.receiveTable.get(socketID);
            if (vector == null) {
                vector = new Vector<Object>();
                this.receiveTable.put(socketID, vector);
            }
        }
        vector.add(obj);
        SequenceContainer seqList = (SequenceContainer)this.sequenceTable.get(socketID);
        seqList.unregisterSequence((Integer)((Object[])controlInfo)[0], this);
        ReplyCollector replyCollector = this;
        synchronized (replyCollector) {
            --this.totalNum;
            if (this.totalNum == 0) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(Exception exception, SocketStream socketStream) {
        SequenceContainer list = (SequenceContainer)this.sequenceTable.remove(socketStream.getSocketID());
        list.unregisterAllSequences(this);
        this.isClosed = true;
        ReplyCollector replyCollector = this;
        synchronized (replyCollector) {
            this.notifyAll();
        }
    }

    public Map getResponseMap() {
        return this.receiveTable;
    }
}

