/*
 * Decompiled with CFR 0.152.
 */
package jeus.net.impl;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import jeus.net.impl.NodeInfo;

public class ClusterInfo
implements Serializable {
    private Vector nodeList;
    private NodeInfo localnode;

    public ClusterInfo(String host, int port) {
        this.localnode = new NodeInfo(host, port);
        this.nodeList = new Vector(10);
    }

    public void addNode(NodeInfo nodeInfo) {
        this.nodeList.add(nodeInfo);
    }

    public int getNodeCount() {
        return this.nodeList.size();
    }

    public NodeInfo getLocalNode() {
        return this.localnode;
    }

    public NodeInfo getLocalNode(String virtualID, int connectionType) {
        return new NodeInfo(this.localnode.getHost(), this.localnode.getBasePort(), virtualID, connectionType);
    }

    public NodeInfo getLocalNode(String virtualID) {
        return new NodeInfo(this.localnode.getHost(), this.localnode.getBasePort(), virtualID);
    }

    public NodeInfo getLocalNode(int virtualPort, int type) {
        return new NodeInfo(this.localnode.getHost(), virtualPort, null, type);
    }

    public Enumeration getNodes() {
        return this.nodeList.elements();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.nodeList.size(); ++i) {
            buffer.append("[");
            buffer.append(((NodeInfo)this.nodeList.get(i)).toString());
            buffer.append("]");
            if (i >= this.nodeList.size() - 1) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }
}

