/*
 * Decompiled with CFR 0.152.
 */
package jeus.net.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import jeus.net.SocketID;
import jeus.net.SocketStream;
import jeus.net.impl.ConnectionManagerEntry;
import jeus.net.impl.CrossConnectionException;
import jeus.net.impl.Ticket;
import jeus.util.ArrayUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Network;

public class ConnectionManager {
    private SocketID localListenSocketID;
    private final HashMap ticketTable = new HashMap();
    private HashMap connectionManagerEntryMap = new HashMap();
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.net");

    public synchronized void destroy() {
        if (logger.isLoggable(JeusMessage_Network._600_LEVEL)) {
            logger.log(JeusMessage_Network._600_LEVEL, JeusMessage_Network._600, (Object)this.localListenSocketID);
        }
        if (this.connectionManagerEntryMap == null) {
            return;
        }
        Iterator i = this.connectionManagerEntryMap.values().iterator();
        while (i.hasNext()) {
            ConnectionManagerEntry connectionManagerEntry = (ConnectionManagerEntry)i.next();
            connectionManagerEntry.destroy();
        }
        this.connectionManagerEntryMap = null;
    }

    public ConnectionManager(SocketID socketID) {
        this.localListenSocketID = socketID;
    }

    public synchronized boolean remove(SocketStream ss) {
        SocketID socketID;
        if (logger.isLoggable(JeusMessage_Network._601_LEVEL)) {
            logger.log(JeusMessage_Network._601_LEVEL, JeusMessage_Network._601, new Object[]{ss, this.localListenSocketID});
        }
        if ((socketID = ss.getSocketID()) == null) {
            return false;
        }
        Integer key = new Integer(socketID.getConnectionType());
        if (this.connectionManagerEntryMap == null) {
            return false;
        }
        ConnectionManagerEntry entry = (ConnectionManagerEntry)this.connectionManagerEntryMap.get(key);
        if (entry == null) {
            return false;
        }
        return entry.remove(ss);
    }

    public synchronized SocketStream getSocketStream(SocketID socketID) {
        Integer key = new Integer(socketID.getConnectionType());
        if (this.connectionManagerEntryMap == null) {
            if (logger.isLoggable(JeusMessage_Network._602_LEVEL)) {
                logger.log(JeusMessage_Network._602_LEVEL, JeusMessage_Network._602, (Object)this.localListenSocketID);
            }
            return null;
        }
        ConnectionManagerEntry entry = (ConnectionManagerEntry)this.connectionManagerEntryMap.get(key);
        if (entry == null) {
            if (logger.isLoggable(JeusMessage_Network._603_LEVEL)) {
                logger.log(JeusMessage_Network._603_LEVEL, JeusMessage_Network._603, new Object[]{socketID, this.localListenSocketID});
            }
            return null;
        }
        return entry.getSocketStream(socketID);
    }

    public synchronized SocketStream[] getSocketStreams(int connectionType) {
        if (logger.isLoggable(JeusMessage_Network._604_LEVEL)) {
            logger.log(JeusMessage_Network._604_LEVEL, JeusMessage_Network._604, (Object)String.valueOf(connectionType));
        }
        Integer key = new Integer(connectionType);
        if (this.connectionManagerEntryMap == null) {
            return SocketStream.DUMMY_ARRAY;
        }
        ConnectionManagerEntry entry = (ConnectionManagerEntry)this.connectionManagerEntryMap.get(key);
        if (entry == null) {
            if (logger.isLoggable(JeusMessage_Network._605_LEVEL)) {
                logger.log(JeusMessage_Network._605_LEVEL, JeusMessage_Network._605, new Object[]{this.localListenSocketID, String.valueOf(connectionType)});
            }
            return SocketStream.DUMMY_ARRAY;
        }
        return entry.getSocketStreams();
    }

    public synchronized SocketStream[] getSocketStreams() {
        if (logger.isLoggable(JeusMessage_Network._606_LEVEL)) {
            logger.log(JeusMessage_Network._606_LEVEL, JeusMessage_Network._606, (Object)this.localListenSocketID);
        }
        ArrayList<SocketStream[]> list = new ArrayList<SocketStream[]>();
        if (this.connectionManagerEntryMap == null) {
            return SocketStream.DUMMY_ARRAY;
        }
        Iterator i = this.connectionManagerEntryMap.values().iterator();
        while (i.hasNext()) {
            ConnectionManagerEntry connectionManagerEntry = (ConnectionManagerEntry)i.next();
            list.add(connectionManagerEntry.getSocketStreams());
        }
        return (SocketStream[])ArrayUtil.concatArrays((Object[][])list.toArray((T[])new SocketStream[0][]));
    }

    public SocketID getLocalListenSocketID() {
        return this.localListenSocketID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ticket getConnectionTicket(SocketID socketID) {
        Ticket ticket;
        if (logger.isLoggable(JeusMessage_Network._607_LEVEL)) {
            logger.log(JeusMessage_Network._607_LEVEL, JeusMessage_Network._607, new Object[]{socketID, this.localListenSocketID});
        }
        Object object = this.ticketTable;
        synchronized (object) {
            ticket = (Ticket)this.ticketTable.get(socketID);
            if (ticket == null) {
                ticket = this.createConnectionTicket(socketID);
            } else {
                ticket.increaseWaitingCount();
            }
        }
        if (!ticket.isOwnedByCurrentThread()) {
            object = ticket;
            synchronized (object) {
                if (ticket.getCount() > 0) {
                    try {
                        ticket.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return ticket;
    }

    private Ticket createConnectionTicket(SocketID socketID) {
        Ticket ticket = new Ticket();
        this.ticketTable.put(socketID, ticket);
        return ticket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ticket getAcceptTicket(SocketID peerSocketID) throws IOException {
        HashMap hashMap = this.ticketTable;
        synchronized (hashMap) {
            Ticket ticket = (Ticket)this.ticketTable.get(peerSocketID);
            if (ticket != null) {
                if (!peerSocketID.needConnect(this.localListenSocketID)) {
                    if (logger.isLoggable(JeusMessage_Network._608_LEVEL)) {
                        logger.log(JeusMessage_Network._608_LEVEL, JeusMessage_Network._608);
                    }
                    throw new CrossConnectionException("connection overruled");
                }
                ticket.increaseWaitingCount();
            } else {
                ticket = this.createConnectionTicket(peerSocketID);
            }
            return ticket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseTicket(SocketID socketID) {
        if (logger.isLoggable(JeusMessage_Network._609_LEVEL)) {
            logger.log(JeusMessage_Network._609_LEVEL, JeusMessage_Network._609, new Object[]{socketID, this.localListenSocketID});
        }
        HashMap hashMap = this.ticketTable;
        synchronized (hashMap) {
            Ticket ticket;
            Ticket ticket2 = ticket = (Ticket)this.ticketTable.get(socketID);
            synchronized (ticket2) {
                if (ticket.getCount() == 0) {
                    this.ticketTable.remove(socketID);
                } else {
                    ticket.decreaseWaitingCount();
                    ticket.notify();
                }
            }
        }
    }

    public synchronized void addConnection(SocketStream socketStream, int connectionType) {
        if (socketStream == null || socketStream.isClosed()) {
            if (logger.isLoggable(JeusMessage_Network._616_LEVEL)) {
                logger.log(JeusMessage_Network._616_LEVEL, JeusMessage_Network._616, (Object)socketStream);
            }
            return;
        }
        if (logger.isLoggable(JeusMessage_Network._610_LEVEL)) {
            logger.log(JeusMessage_Network._610_LEVEL, JeusMessage_Network._610, new Object[]{socketStream, this.localListenSocketID});
        }
        Integer key = new Integer(connectionType);
        if (this.connectionManagerEntryMap == null) {
            return;
        }
        ConnectionManagerEntry entry = (ConnectionManagerEntry)this.connectionManagerEntryMap.get(key);
        if (entry == null) {
            entry = new ConnectionManagerEntry();
            this.connectionManagerEntryMap.put(key, entry);
        }
        entry.setConnection(socketStream);
        this.notifyAll();
    }
}

