/*
 * Decompiled with CFR 0.152.
 */
package jeus.net.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jeus.net.SocketID;
import jeus.net.SocketStream;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Network;

class ConnectionManagerEntry {
    private Map socketStreams = new HashMap();
    private SocketStream[] streamArray;
    private boolean invalidStreamArray = true;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.net");

    ConnectionManagerEntry() {
    }

    public synchronized boolean remove(SocketStream socketStream) {
        SocketID socketID;
        SocketStream ss;
        if (logger.isLoggable(JeusMessage_Network._611_LEVEL)) {
            logger.log(JeusMessage_Network._611_LEVEL, JeusMessage_Network._611, (Object)socketStream);
        }
        if ((ss = (SocketStream)this.socketStreams.get(socketID = socketStream.getSocketID())) != null && ss == socketStream) {
            this.socketStreams.remove(socketID);
            this.invalidStreamArray = true;
            return true;
        }
        return false;
    }

    synchronized void destroy() {
        if (logger.isLoggable(JeusMessage_Network._612_LEVEL)) {
            logger.log(JeusMessage_Network._612_LEVEL, JeusMessage_Network._612);
        }
        Collection streams = this.socketStreams.values();
        SocketStream[] sock = streams.toArray(new SocketStream[streams.size()]);
        for (int i = 0; i < sock.length; ++i) {
            sock[i].destroy();
        }
    }

    synchronized void setConnection(SocketStream _sockStream) {
        SocketID socketID;
        SocketStream prevSockStream;
        if (logger.isLoggable(JeusMessage_Network._613_LEVEL)) {
            logger.log(JeusMessage_Network._613_LEVEL, JeusMessage_Network._613, (Object)_sockStream);
        }
        if ((prevSockStream = (SocketStream)this.socketStreams.get(socketID = _sockStream.getSocketID())) != null) {
            if (prevSockStream.getSocketID().equals(prevSockStream.getLocalSocketID())) {
                return;
            }
            if (logger.isLoggable(JeusMessage_Network._614_LEVEL)) {
                logger.log(JeusMessage_Network._614_LEVEL, JeusMessage_Network._614, (Object)_sockStream);
            }
            prevSockStream.destroy();
        }
        this.socketStreams.put(socketID, _sockStream);
        this.invalidStreamArray = true;
    }

    public synchronized SocketStream getSocketStream(SocketID serverName) {
        if (logger.isLoggable(JeusMessage_Network._615_LEVEL)) {
            logger.log(JeusMessage_Network._615_LEVEL, JeusMessage_Network._615, (Object)serverName);
        }
        return (SocketStream)this.socketStreams.get(serverName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketStream[] getSocketStreams() {
        if (this.invalidStreamArray) {
            ConnectionManagerEntry connectionManagerEntry = this;
            synchronized (connectionManagerEntry) {
                if (this.invalidStreamArray) {
                    Collection streams = this.socketStreams.values();
                    this.streamArray = streams.toArray(new SocketStream[streams.size()]);
                    this.invalidStreamArray = false;
                }
            }
        }
        return this.streamArray;
    }
}

