/*
 * Decompiled with CFR 0.152.
 */
package jeus.net.impl;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import jeus.io.Selector;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.handler.StreamContentReceiver;
import jeus.io.helper.IOComponentCreator;
import jeus.io.impl.StreamHandlerImpl;
import jeus.net.ConnectionListener;
import jeus.net.ConnectionListenerFactory;
import jeus.net.ConnectorException;
import jeus.net.Endpoint;
import jeus.net.LocalBindingNoListenID;
import jeus.net.NetworkControlPacket;
import jeus.net.SocketID;
import jeus.net.SocketStream;
import jeus.net.impl.ConnectionManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Network;
import jeus.util.properties.JeusNetProperties;

public class Connector {
    public static final int SLEEP_TIME = 3000;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.net");
    private final ConnectionManager connectionManager;
    private jeus.io.Connector connector;
    private jeus.io.Connector onePortConnector;
    private Selector selector;
    private StreamContentHandlerCreator contentHandlerCreator;
    private ConnectionListenerFactory listenerFactory;
    private IOComponentCreator creator;
    private Object sslContext;
    private static final Map sslProperty = new HashMap();
    private boolean onlyByteTransfer;

    public Connector(Selector selector, ConnectionManager connectionManager, IOComponentCreator creator, StreamContentHandlerCreator contentHandlerCreator, ConnectionListenerFactory listenerFactory, Object sslContext, boolean onlyByteTransfer) {
        if (logger.isLoggable(JeusMessage_Network._700_LEVEL)) {
            logger.log(JeusMessage_Network._700_LEVEL, JeusMessage_Network._700, (Object)(connectionManager == null ? null : connectionManager.getLocalListenSocketID()));
        }
        this.selector = selector;
        this.connectionManager = connectionManager;
        this.connector = creator.createConnector(sslContext, sslProperty);
        this.connector.setTimeout(JeusNetProperties.CONNECT_TIMEOUT);
        this.onePortConnector = creator.createOnePortConnector(sslContext);
        this.onePortConnector.setTimeout(JeusNetProperties.CONNECT_TIMEOUT);
        this.creator = creator;
        this.contentHandlerCreator = contentHandlerCreator;
        this.listenerFactory = listenerFactory;
        this.sslContext = sslContext;
        this.onlyByteTransfer = onlyByteTransfer;
    }

    public SocketStream tryToConnect(SocketID remoteSocketID, int _tryCount, Object piggybackedData, int connectTimeout, int readTimeout, int sleepTime) throws ConnectorException {
        return this.tryToConnect(remoteSocketID, null, _tryCount, piggybackedData, connectTimeout, readTimeout, sleepTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketStream tryToConnect(SocketID remoteSocketID, LocalBindingNoListenID localSocketID, int _tryCount, Object piggybackedData, int connectTimeout, int readTimeout, int sleepTime) throws ConnectorException {
        String node = null;
        try {
            node = Endpoint.getConnectionID(remoteSocketID);
        }
        catch (UnknownHostException e) {
            throw new ConnectorException("Cannot connect to the socketID " + remoteSocketID, e);
        }
        if (logger.isLoggable(JeusMessage_Network._701_LEVEL)) {
            logger.log(JeusMessage_Network._701_LEVEL, JeusMessage_Network._701, (Object)node);
        }
        IOException lastException = null;
        int i = _tryCount;
        while (true) {
            block26: {
                if (i <= 0) {
                    throw new ConnectorException("fail to connect to " + node + ", the node is not ready or protocol is different", lastException);
                }
                try {
                    SocketStream sockStream;
                    String localHost = localSocketID != null ? localSocketID.getLocalHost() : null;
                    int localPort = localSocketID != null ? localSocketID.getLocalPort() : 0;
                    String virtualID = remoteSocketID.getVirtualID();
                    Socket socket = virtualID != null ? this.onePortConnector.connect(remoteSocketID.getHost(), remoteSocketID.getBasePort(), localHost, localPort, virtualID, connectTimeout, readTimeout) : this.connector.connect(remoteSocketID.getHost(), remoteSocketID.getBasePort(), localHost, localPort, null, connectTimeout, readTimeout);
                    if (logger.isLoggable(JeusMessage_Network._702_LEVEL)) {
                        logger.log(JeusMessage_Network._702_LEVEL, JeusMessage_Network._702, (Object)node);
                    }
                    if (!(sockStream = this.registerSelectSet(socket, piggybackedData, remoteSocketID)).isEstablished()) {
                        boolean isCrossConnected = sockStream.isCrossClosed();
                        sockStream.destroy();
                        if (!isCrossConnected) break block26;
                        if (logger.isLoggable(JeusMessage_Network._704_LEVEL)) {
                            logger.log(JeusMessage_Network._704_LEVEL, JeusMessage_Network._704, new Object[]{node, this.connectionManager == null ? null : this.connectionManager.getLocalListenSocketID()});
                        }
                        if ((sockStream = this.connectionManager.getSocketStream(remoteSocketID)) == null) {
                            ConnectionManager connectionManager = this.connectionManager;
                            synchronized (connectionManager) {
                                try {
                                    if (logger.isLoggable(JeusMessage_Network._705_LEVEL)) {
                                        logger.log(JeusMessage_Network._705_LEVEL, JeusMessage_Network._705, (Object)node);
                                    }
                                    this.connectionManager.wait(JeusNetProperties.CROSS_CONNECT_WAIT_TIMEOUT);
                                    sockStream = this.connectionManager.getSocketStream(remoteSocketID);
                                    if (sockStream == null) {
                                        throw new IOException("can not wait for incoming connection any more");
                                    }
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                            }
                        }
                        if (logger.isLoggable(JeusMessage_Network._706_LEVEL)) {
                            logger.log(JeusMessage_Network._706_LEVEL, JeusMessage_Network._706, (Object)node);
                        }
                        return sockStream;
                    }
                    if (logger.isLoggable(JeusMessage_Network._707_LEVEL)) {
                        logger.log(JeusMessage_Network._707_LEVEL, JeusMessage_Network._707, (Object)node);
                    }
                    return sockStream;
                }
                catch (IOException e) {
                    lastException = e;
                    if (logger.isLoggable(JeusMessage_Network._708_LEVEL)) {
                        logger.log(JeusMessage_Network._708_LEVEL, JeusMessage_Network._708, remoteSocketID, (Throwable)e);
                    }
                    if (i <= 0) {
                        throw new ConnectorException("fail to connect to " + node + ", exception : " + e.getMessage());
                    }
                    if (logger.isLoggable(JeusMessage_Network._709_LEVEL)) {
                        logger.log(JeusMessage_Network._709_LEVEL, JeusMessage_Network._709, (Object[])new String[]{node, String.valueOf(_tryCount - i + 1)});
                    }
                    try {
                        if (i > 1) {
                            Thread.sleep(sleepTime);
                        }
                    }
                    catch (InterruptedException e1) {
                        // empty catch block
                    }
                }
            }
            --i;
        }
    }

    public SocketStream tryToConnect(SocketID socketID, int _tryCount, Object piggybackedData, int connectTimeout, int readTimeout) throws ConnectorException {
        return this.tryToConnect(socketID, _tryCount, piggybackedData, connectTimeout, readTimeout, 3000);
    }

    public SocketStream tryToConnect(SocketID remoteSocketID, LocalBindingNoListenID localSocketID, int _tryCount, Object piggybackedData, int connectTimeout, int readTimeout) throws ConnectorException {
        return this.tryToConnect(remoteSocketID, localSocketID, _tryCount, piggybackedData, connectTimeout, readTimeout, 3000);
    }

    private SocketStream addSockStreamFromConnector(Socket socket, SocketID socketID) throws IOException {
        if (logger.isLoggable(JeusMessage_Network._710_LEVEL)) {
            logger.log(JeusMessage_Network._710_LEVEL, JeusMessage_Network._710, (Object)socket);
        }
        ConnectionListener listener = this.listenerFactory.createConnectionListener(socket, socketID);
        if (logger.isLoggable(JeusMessage_Network._711_LEVEL)) {
            logger.log(JeusMessage_Network._711_LEVEL, JeusMessage_Network._711, (Object)socket);
        }
        SocketStream sockStream = SocketStream.createSocketStream(socket, this.connectionManager, listener, this.onlyByteTransfer);
        listener.connectionConnected(sockStream);
        if (logger.isLoggable(JeusMessage_Network._712_LEVEL)) {
            logger.log(JeusMessage_Network._712_LEVEL, JeusMessage_Network._712, (Object)socket);
        }
        StreamHandlerImpl endpoint = this.creator.createStreamHandler((Object)socket, (StreamContentReceiver)sockStream, this.contentHandlerCreator, this.sslContext, sslProperty);
        sockStream.setEndpoint(endpoint);
        if (logger.isLoggable(JeusMessage_Network._713_LEVEL)) {
            logger.log(JeusMessage_Network._713_LEVEL, JeusMessage_Network._713, new Object[]{socket, this.connectionManager == null ? null : this.connectionManager.getLocalListenSocketID()});
        }
        this.selector.addSelectItem(endpoint);
        return sockStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketStream registerSelectSet(Socket sock, Object piggybackedData, SocketID socketID) throws IOException {
        SocketStream sockStream = this.addSockStreamFromConnector(sock, socketID);
        sockStream.setSocketID(socketID);
        SocketStream socketStream = sockStream;
        synchronized (socketStream) {
            SocketID mySocketID = this.connectionManager.getLocalListenSocketID();
            NetworkControlPacket packet = new NetworkControlPacket(1, mySocketID.getConnectionType());
            packet.setSocketID(mySocketID);
            packet.setData(sockStream.getListener().getPiggybackData(1, sockStream, piggybackedData));
            sockStream.write(packet);
            try {
                if (logger.isLoggable(JeusMessage_Network._714_LEVEL)) {
                    logger.log(JeusMessage_Network._714_LEVEL, JeusMessage_Network._714, (Object)socketID);
                }
                sockStream.wait(JeusNetProperties.CONNECT_TIMEOUT * 2);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return sockStream;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connector.setTimeout(connectTimeout);
    }

    public SocketStream getSocketStream(SocketID remoteSocketID, int _tryCount, Object piggybackedData, int connectTimeout, int readTimeout, int sleepTime) throws ConnectorException {
        return this.getSocketStream(remoteSocketID, null, _tryCount, piggybackedData, connectTimeout, readTimeout, sleepTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketStream getSocketStream(SocketID remoteSocketID, LocalBindingNoListenID localSocketID, int _tryCount, Object piggybackedData, int connectTimeout, int readTimeout, int sleepTime) throws ConnectorException {
        SocketStream sockStream = this.connectionManager.getSocketStream(remoteSocketID);
        if (sockStream == null) {
            if (remoteSocketID.isNotConnectable()) {
                return null;
            }
            this.connectionManager.getConnectionTicket(remoteSocketID);
            try {
                sockStream = this.connectionManager.getSocketStream(remoteSocketID);
                if (sockStream == null) {
                    if (logger.isLoggable(JeusMessage_Network._715_LEVEL)) {
                        logger.log(JeusMessage_Network._715_LEVEL, JeusMessage_Network._715, (Object)remoteSocketID);
                    }
                    sockStream = this.tryToConnect(remoteSocketID, localSocketID, _tryCount, piggybackedData, connectTimeout, readTimeout, sleepTime);
                    sockStream = this.connectionManager.getSocketStream(remoteSocketID);
                } else if (sockStream.isClosed()) {
                    if (logger.isLoggable(JeusMessage_Network._716_LEVEL)) {
                        logger.log(JeusMessage_Network._716_LEVEL, JeusMessage_Network._716, (Object)sockStream);
                    }
                    this.connectionManager.remove(sockStream);
                    sockStream = this.tryToConnect(remoteSocketID, localSocketID, _tryCount, piggybackedData, connectTimeout, readTimeout, sleepTime);
                }
            }
            finally {
                this.connectionManager.releaseTicket(remoteSocketID);
            }
        }
        return sockStream;
    }

    static {
        sslProperty.put("useClientMode", Boolean.TRUE);
    }
}

