/*
 * Decompiled with CFR 0.152.
 */
package jeus.net.impl;

import java.net.InetAddress;
import java.util.logging.Level;
import jeus.net.SocketID;
import jeus.util.logging.JeusLogger;
import jeus.util.properties.JeusNetPropertyValues;

public class NodeInfo
implements SocketID {
    private static final long serialVersionUID = 2162307734134523000L;
    protected String host;
    protected int port;
    protected String virtualID;
    protected int type;
    protected String realNodeName;
    protected boolean notConnectable;

    public NodeInfo(String host, int port) {
        this(host, port, null, -1);
    }

    public NodeInfo(String host, int port, int type) {
        this(host, port, null, type);
    }

    public NodeInfo(String host, int port, String virtualID) {
        this(host, port, virtualID, -1);
    }

    public NodeInfo(String host, int port, String virtualID, int type) {
        this.host = host = this.checkLocalHost(host);
        this.port = port;
        this.virtualID = virtualID;
        this.type = type;
        this.realNodeName = host + ":" + port;
    }

    private String checkLocalHost(String host) {
        if (host.startsWith("127.") || host.equals("localhost")) {
            host = JeusNetPropertyValues.LOCAL_HOSTADDRESS;
        }
        return host;
    }

    public String getHost() {
        return this.host;
    }

    public int getBasePort() {
        return this.port;
    }

    public String toString() {
        return this.host + ":" + this.port + "(" + this.virtualID + ")";
    }

    public boolean equals(Object obj) {
        if (obj instanceof NodeInfo) {
            NodeInfo other = (NodeInfo)obj;
            String thisHost = this.host;
            String otherHost = other.getHost();
            try {
                if (thisHost.indexOf(46) > 0 && otherHost.indexOf(46) < 0) {
                    otherHost = InetAddress.getByName(otherHost).getHostAddress();
                } else if (thisHost.indexOf(46) < 0 && otherHost.indexOf(46) > 0) {
                    thisHost = InetAddress.getByName(thisHost).getHostAddress();
                }
            }
            catch (Throwable t) {
                JeusLogger.getLogger("jeus.net").log(Level.SEVERE, "can not exchange hostName to IP " + thisHost + " , " + otherHost);
            }
            if (this.virtualID == null) {
                if (other.getVirtualID() != null) {
                    return false;
                }
                return otherHost.equals(thisHost) && other.getBasePort() == this.port;
            }
            return otherHost.equals(thisHost) && other.getBasePort() == this.port && other.getVirtualID().equals(this.virtualID);
        }
        return false;
    }

    public boolean isSameHostPort(NodeInfo other) {
        return other.getHost().equals(this.host) && other.getBasePort() == this.port;
    }

    public int hashCode() {
        if (this.virtualID != null) {
            return this.host.hashCode() ^ this.port ^ this.virtualID.hashCode();
        }
        return this.host.hashCode() ^ this.port;
    }

    public boolean needConnect(SocketID socketID) {
        if (socketID instanceof NodeInfo) {
            NodeInfo nodeInfo = (NodeInfo)socketID;
            if (this.host.compareTo(nodeInfo.host) > 0) {
                return true;
            }
            if (this.host.equals(nodeInfo.host)) {
                if (this.port == nodeInfo.port) {
                    if (this.virtualID != null && nodeInfo.virtualID != null) {
                        return this.virtualID.compareTo(nodeInfo.virtualID) > 0;
                    }
                    return false;
                }
                return this.port > nodeInfo.port;
            }
            return false;
        }
        return false;
    }

    public String getVirtualID() {
        return this.virtualID;
    }

    public int getConnectionType() {
        return this.type;
    }

    public void setConnectionType(int type) {
        this.type = type;
    }

    public void setNotConnectable() {
        this.notConnectable = true;
    }

    public boolean isNotConnectable() {
        return this.notConnectable;
    }

    public String getRealNodeName() {
        return this.realNodeName;
    }
}

