/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.resource;

import java.security.Permission;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ResourcePermission
extends Permission {
    private ArrayList actions = new ArrayList();
    private String stringActions = "";

    public ResourcePermission(String name) {
        this(name, "");
    }

    public ResourcePermission(String name, String actions) {
        super(name);
        if (actions == null) {
            this.actions.add("");
        } else {
            this.stringActions = actions.trim();
            if (this.stringActions.indexOf(44) > 0) {
                this.actions = new ArrayList();
                StringTokenizer st = new StringTokenizer(this.stringActions, ",");
                while (st.hasMoreTokens()) {
                    this.actions.add(st.nextToken().trim());
                }
            } else {
                this.actions.add(actions);
            }
        }
    }

    public boolean equals(Object anotherObject) {
        if (anotherObject == null) {
            return false;
        }
        if (anotherObject == this) {
            return true;
        }
        if (anotherObject instanceof ResourcePermission) {
            ResourcePermission resPerm = (ResourcePermission)anotherObject;
            return this.getName().equals(resPerm.getName()) && this.actions.equals(resPerm.actions);
        }
        return false;
    }

    public String getActions() {
        return this.stringActions;
    }

    public int hashCode() {
        if (this.actions == null) {
            return this.getName().hashCode();
        }
        return this.getName().hashCode() + this.actions.hashCode();
    }

    public boolean implies(Permission anotherPermission) {
        if (anotherPermission == null) {
            return false;
        }
        if (anotherPermission == this) {
            return true;
        }
        if (anotherPermission instanceof ResourcePermission) {
            ResourcePermission otherRP = (ResourcePermission)anotherPermission;
            if (this.nameImplies(this.getName(), otherRP.getName())) {
                if (this.getActions().equals("*")) {
                    return true;
                }
                if (this.actions.containsAll(otherRP.actions)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean nameImplies(String myName, String otherName) {
        if (myName.equals("*")) {
            return true;
        }
        int starIndex = myName.indexOf("*");
        if (starIndex < 0) {
            return otherName.equals(myName);
        }
        String noStar = myName.substring(0, starIndex);
        return otherName.startsWith(noStar);
    }
}

