/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.util.List;
import jeus.util.CommonExecutor;
import jeus.util.RefinedThreadPoolExecutor;
import jeus.util.ShutdownHandler;

public class CommonExecutorAdaptor
implements CommonExecutor {
    private RefinedThreadPoolExecutor executor;

    public CommonExecutorAdaptor(RefinedThreadPoolExecutor refinedThreadPoolExecutor) {
        this.executor = refinedThreadPoolExecutor;
    }

    public void shutdownNow(ShutdownHandler handler) {
        List runnableList = this.executor.shutdownNow();
        if (handler == null) {
            return;
        }
        for (int i = 0; i < runnableList.size(); ++i) {
            Runnable runnable = (Runnable)runnableList.get(i);
            handler.shutdown(runnable);
        }
    }

    public int getPoolSize() {
        return this.executor.getPoolSize();
    }

    public int getWorkingSize() {
        return this.executor.getActiveCount();
    }

    public int getWaitingCount() {
        return this.executor.getQueue().size();
    }

    public boolean isEmpty() {
        return this.executor.getQueue().size() == 0;
    }

    public int getActiveCount() {
        return this.executor.getActiveCount();
    }

    public void execute(Runnable command) throws InterruptedException {
        this.executor.execute(command);
    }
}

