/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import jeus.util.HashMap;

public class LinkedHashMap
extends HashMap {
    private transient Entry header;
    private final boolean accessOrder;

    public LinkedHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.accessOrder = false;
    }

    public LinkedHashMap(int initialCapacity) {
        super(initialCapacity);
        this.accessOrder = false;
    }

    public LinkedHashMap() {
        this.accessOrder = false;
    }

    public LinkedHashMap(Map m) {
        super(m);
        this.accessOrder = false;
    }

    public LinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder) {
        super(initialCapacity, loadFactor);
        this.accessOrder = accessOrder;
    }

    void init() {
        this.header.before = this.header.after = (this.header = new Entry(-1, null, null, null));
    }

    void transfer(HashMap.Entry[] newTable) {
        int newCapacity = newTable.length;
        Entry e = this.header.after;
        while (e != this.header) {
            int index = HashMap.indexFor(e.hash, newCapacity);
            e.next = newTable[index];
            newTable[index] = e;
            e = e.after;
        }
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            Entry e = this.header.after;
            while (e != this.header) {
                if (e.value == null) {
                    return true;
                }
                e = e.after;
            }
        } else {
            Entry e = this.header.after;
            while (e != this.header) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.after;
            }
        }
        return false;
    }

    public Iterator getCirculatedEntryIterator(Object start) {
        Entry entry = (Entry)start;
        if (entry == null || !this.containsKey(entry.getKey())) {
            return new EntryIterator();
        }
        return new CirculatedEntryIterator(entry);
    }

    public Iterator getCirculatedKeyIterator(Object key) {
        if (key == null || !this.containsKey(key)) {
            return new KeyIterator();
        }
        Entry entry = (Entry)this.getEntry(key);
        return new CirculatedKeyIterator(entry);
    }

    public Iterator getCirculatedValueIterator(Object key) {
        if (key == null || !this.containsKey(key)) {
            return new ValueIterator();
        }
        Entry entry = (Entry)this.getEntry(key);
        return new CirculatedValueIterator(entry);
    }

    public Object peekEldest() {
        Entry first = this.header.after;
        return first == this.header ? null : first.getKey();
    }

    public static void main(String[] args) {
        int i;
        LinkedHashMap map = new LinkedHashMap();
        map.put(new Integer(1), "navis");
        map.put(new Integer(2), "todo");
        map.put(new Integer(3), "remove");
        map.put(new Integer(4), "this");
        LinkedHashMap map2 = new LinkedHashMap();
        map2.put(new Integer(5), "navis2");
        map2.put(new Integer(6), "todo2");
        map2.put(new Integer(7), "remove2");
        map2.put(new Integer(8), "this2");
        LinkedList list = new LinkedList(map.entrySet());
        LinkedList keys = new LinkedList(map.keySet());
        Iterator it = map.getCirculatedEntryIterator(null);
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            System.out.println(entry);
        }
        System.out.println("");
        for (i = 0; i < list.size(); ++i) {
            it = map.getCirculatedEntryIterator(list.get(i));
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                System.out.println(entry);
            }
            System.out.println("");
        }
        for (i = 0; i < list.size(); ++i) {
            it = map.getCirculatedKeyIterator(keys.get(i));
            while (it.hasNext()) {
                System.out.println(it.next());
            }
            System.out.println("");
        }
        for (i = 0; i < list.size() + 4; ++i) {
            System.out.println(i + ":" + map.getEntry(i));
        }
        map.recover(map2);
        System.out.println(map);
    }

    public Object recover(Object key, Object value) {
        return this.putAsEldest(key, value);
    }

    public void recover(LinkedHashMap t) {
        int n = t.size();
        if (n == 0) {
            return;
        }
        if (n >= this.threshold) {
            int capacity;
            if ((n = (int)((float)n / this.loadFactor + 1.0f)) > 0x40000000) {
                n = 0x40000000;
            }
            for (capacity = this.table.length; capacity < n; capacity <<= 1) {
            }
            this.resize(capacity);
        }
        Entry e = t.header.before;
        while (e != t.header) {
            this.putAsEldest(e.getKey(), e.getValue());
            e = e.before;
        }
    }

    private Object putAsEldest(Object key, Object value) {
        Object k = HashMap.maskNull(key);
        int hash = HashMap.hash(k);
        int i = HashMap.indexFor(hash, this.table.length);
        HashMap.Entry e = this.table[i];
        while (e != null) {
            if (e.hash == hash && HashMap.eq(k, e.key)) {
                Object oldValue = e.value;
                e.value = value;
                e.recordAccess(this);
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        this.table[i] = e = new Entry(hash, key, value, this.table[i]);
        ((Entry)e).addAfter(this.header);
        ++this.size;
        if (this.size >= this.threshold) {
            this.resize(2 * this.table.length);
        }
        return null;
    }

    public Object getKey(Object key) {
        Object k = HashMap.maskNull(key);
        int hash = HashMap.hash(k);
        int i = HashMap.indexFor(hash, this.table.length);
        HashMap.Entry e = this.table[i];
        while (e != null) {
            if (e.hash == hash && HashMap.eq(k, e.key)) {
                return e.key;
            }
            e = e.next;
        }
        return null;
    }

    public HashMap.Entry getEntry(Object key) {
        return super.getEntry(key);
    }

    public Entry getEntry(int nth) {
        boolean forward = true;
        if (nth > this.size - 1) {
            return this.header.after;
        }
        if (nth >= this.size / 2) {
            nth = this.size - nth - 1;
            forward = false;
        }
        Entry entry = forward ? this.header.after : this.header.before;
        for (int i = 0; i < nth; ++i) {
            entry = forward ? entry.after : entry.before;
        }
        return entry == this.header ? null : entry;
    }

    public Object getKey(int nth) {
        Entry entry = this.getEntry(nth);
        return entry == null ? null : entry.getKey();
    }

    public Object getValue(int index) {
        Entry entry = this.getEntry(index);
        return entry == null ? null : entry.getValue();
    }

    public Object get(Object key) {
        Entry e = (Entry)this.getEntry(key);
        if (e == null) {
            return null;
        }
        e.recordAccess(this);
        return e.value;
    }

    public Object removeYoungestValue() {
        Entry first = this.header.before;
        if (first != this.header) {
            return this.remove(first.key);
        }
        return null;
    }

    public Object removeEldestValue() {
        Entry first = this.header.after;
        if (first != this.header) {
            return this.remove(first.key);
        }
        return null;
    }

    public void clear() {
        super.clear();
        this.header.before = this.header.after = this.header;
    }

    Iterator newKeyIterator() {
        return new KeyIterator();
    }

    Iterator newValueIterator() {
        return new ValueIterator();
    }

    Iterator newEntryIterator() {
        return new EntryIterator();
    }

    void addEntry(int hash, Object key, Object value, int bucketIndex) {
        this.createEntry(hash, key, value, bucketIndex);
        Entry eldest = this.header.after;
        if (this.removeEldestEntry(eldest)) {
            this.removeEntryForKey(eldest.key);
        } else if (this.size >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void addEntryPrevOf(Entry next, int hash, Object key, Object value, int bucketIndex) {
        this.createEntryPrev(next, hash, key, value, bucketIndex);
        if (this.size >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void addEntryNextOf(Entry prev, int hash, Object key, Object value, int bucketIndex) {
        this.createEntryNext(prev, hash, key, value, bucketIndex);
        if (this.size >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int hash, Object key, Object value, int bucketIndex) {
        Entry e = new Entry(hash, key, value, this.table[bucketIndex]);
        this.table[bucketIndex] = e;
        e.addBefore(this.header);
        ++this.size;
    }

    void createEntryPrev(Entry next, int hash, Object key, Object value, int bucketIndex) {
        Entry e = new Entry(hash, key, value, this.table[bucketIndex]);
        this.table[bucketIndex] = e;
        e.addBefore(next);
        ++this.size;
    }

    void createEntryNext(Entry prev, int hash, Object key, Object value, int bucketIndex) {
        Entry e = new Entry(hash, key, value, this.table[bucketIndex]);
        this.table[bucketIndex] = e;
        e.addAfter(prev);
        ++this.size;
    }

    protected boolean removeEldestEntry(Map.Entry eldest) {
        return false;
    }

    private class EntryIterator
    extends LinkedHashIterator {
        private EntryIterator() {
        }

        public Object next() {
            return this.nextEntry();
        }
    }

    private class ValueIterator
    extends LinkedHashIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().getValue();
        }
    }

    private class KeyIterator
    extends LinkedHashIterator {
        private KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    private abstract class LinkedHashIterator
    implements Iterator {
        Entry nextEntry;
        Entry lastReturned;
        int expectedModCount;

        private LinkedHashIterator() {
            this.nextEntry = ((LinkedHashMap)LinkedHashMap.this).header.after;
            this.lastReturned = null;
            this.expectedModCount = LinkedHashMap.this.modCount;
        }

        public boolean hasNext() {
            return this.nextEntry != LinkedHashMap.this.header;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (LinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            LinkedHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
            this.expectedModCount = LinkedHashMap.this.modCount;
        }

        Entry nextEntry() {
            if (LinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextEntry == LinkedHashMap.this.header) {
                throw new NoSuchElementException();
            }
            Entry e = this.lastReturned = this.nextEntry;
            this.nextEntry = e.after;
            return e;
        }
    }

    private static class Entry
    extends HashMap.Entry {
        Entry before;
        Entry after;

        Entry(int hash, Object key, Object value, HashMap.Entry next) {
            super(hash, key, value, next);
        }

        private void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        private void addBefore(Entry existingEntry) {
            this.after = existingEntry;
            this.before = existingEntry.before;
            this.before.after = this;
            this.after.before = this;
        }

        private void addAfter(Entry existingEntry) {
            this.after = existingEntry.after;
            this.before = existingEntry;
            this.before.after = this;
            this.after.before = this;
        }

        void recordAccess(HashMap m) {
            LinkedHashMap lm = (LinkedHashMap)m;
            if (lm.accessOrder) {
                ++lm.modCount;
                this.remove();
                this.addBefore(lm.header);
            }
        }

        void recordRemoval(HashMap m) {
            this.remove();
        }
    }

    private abstract class CirculatedIterator
    extends LinkedHashIterator {
        private Entry start;

        CirculatedIterator(Entry start) {
            this.start = start;
            this.nextEntry = start.after;
        }

        public boolean hasNext() {
            return this.lastReturned != this.start;
        }

        public Entry nextEntry() {
            if (LinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastReturned == this.start) {
                throw new NoSuchElementException();
            }
            Entry e = this.lastReturned = this.nextEntry;
            this.nextEntry = e.after;
            if (e == LinkedHashMap.this.header) {
                return this.nextEntry();
            }
            return e;
        }
    }

    private class CirculatedEntryIterator
    extends CirculatedIterator {
        public CirculatedEntryIterator(Entry start) {
            super(start);
        }

        public Object next() {
            return this.nextEntry();
        }
    }

    private class CirculatedValueIterator
    extends CirculatedIterator {
        public CirculatedValueIterator(Entry start) {
            super(start);
        }

        public Object next() {
            return this.nextEntry().getValue();
        }
    }

    private class CirculatedKeyIterator
    extends CirculatedIterator {
        public CirculatedKeyIterator(Entry start) {
            super(start);
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }
}

