/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import jeus.util.CommonExecutor;
import jeus.util.RefinedThreadPoolExecutor;
import jeus.util.ShutdownHandler;
import jeus.util.concurrent50.concurrent.Executor;
import jeus.util.properties.JeusNetProperties;

public class PooledExecutorFactory {
    private static PooledExecutorFactory executorFactory = new PooledExecutorFactory();

    public static Executor createPooledExecutor(String threadNamePrefix) {
        return executorFactory.createPooledExecutorInternal(threadNamePrefix);
    }

    public static Executor createPooledExecutor(String threadNamePrefix, int size) {
        return executorFactory.createPooledExecutorInternal(threadNamePrefix, size);
    }

    public static Executor createPooledExecutor(String threadNamePrefix, int size, boolean isDaemon) {
        return executorFactory.createPooledExecutorInternal(threadNamePrefix, size, isDaemon);
    }

    public static Executor createPooledExecutor(String threadNamePrefix, int size, int initSize) {
        return executorFactory.createPooledExecutorInternal(threadNamePrefix, size, initSize);
    }

    public static Executor createPooledExecutor(String threadNamePrefix, int size, int initSize, long keepAliveTime) {
        return executorFactory.createPooledExecutorInternal(threadNamePrefix, size, initSize, keepAliveTime, true);
    }

    public static Executor createPooledExecutor(String threadNamePrefix, int size, int initSize, long keepAliveTime, boolean isDaemon) {
        return executorFactory.createPooledExecutorInternal(threadNamePrefix, size, initSize, keepAliveTime, isDaemon);
    }

    public static void setPooledExecutorFactory(PooledExecutorFactory factory) {
        executorFactory = factory;
    }

    public Executor createPooledExecutorInternal(String threadNamePrefix) {
        return this.createPooledExecutorInternal(threadNamePrefix, 10, 1);
    }

    protected Executor createPooledExecutorInternal(String threadNamePrefix, int size) {
        int initSize = PooledExecutorFactory.getDefaultInitSize(size);
        return this.createPooledExecutorInternal(threadNamePrefix, size, initSize, JeusNetProperties.THREAD_KEEP_ALIVE_TIME, true);
    }

    protected Executor createPooledExecutorInternal(String threadNamePrefix, int size, boolean isDaemon) {
        int initSize = PooledExecutorFactory.getDefaultInitSize(size);
        return this.createPooledExecutorInternal(threadNamePrefix, size, initSize, JeusNetProperties.THREAD_KEEP_ALIVE_TIME, isDaemon);
    }

    protected Executor createPooledExecutorInternal(String threadNamePrefix, int size, int initSize) {
        return this.createPooledExecutorInternal(threadNamePrefix, size, initSize, JeusNetProperties.THREAD_KEEP_ALIVE_TIME, true);
    }

    protected Executor createPooledExecutorInternal(String threadNamePrefix, int size, int initSize, long keepAliveTime, boolean isDaemon) {
        return new RefinedThreadPoolExecutor(threadNamePrefix, initSize, size, keepAliveTime, isDaemon);
    }

    public static int getDefaultInitSize(int size) {
        int initSize = size / 10;
        if (initSize > 10) {
            initSize = 10;
        } else if (initSize == 0) {
            initSize = 1;
        }
        return initSize;
    }

    public static Executor createPooledExecutor(String threadNamePrefix, int size, long keepalive) {
        return executorFactory.createPooledExecutorInternal(threadNamePrefix, size, PooledExecutorFactory.getDefaultInitSize(size), keepalive, true);
    }

    public static CommonExecutor createThreadCreator(final String name, final boolean isDaemon) {
        return new CommonExecutor(){

            public void shutdownNow(ShutdownHandler handler) {
            }

            public int getPoolSize() {
                return 0;
            }

            public int getWorkingSize() {
                return 0;
            }

            public int getWaitingCount() {
                return 0;
            }

            public boolean isEmpty() {
                return false;
            }

            public int getActiveCount() {
                return 0;
            }

            public void execute(Runnable command) {
                Thread t = new Thread(command, name);
                t.setDaemon(isDaemon);
                t.start();
            }
        };
    }
}

