/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.io.Serializable;

public class Queue
implements Serializable {
    private Object[] queue;
    final int defaultSize = 10;
    private int size;
    private int front;
    private int rear;

    public Queue() {
        this.queue = new Object[10];
        this.size = 10;
    }

    public Queue(int initialSize) {
        this.queue = new Object[initialSize];
        this.size = initialSize;
    }

    public boolean isEmpty() {
        return this.front == this.rear;
    }

    public void add(Object target) {
        this.rear = (this.rear + 1) % this.size;
        if (this.front == this.rear) {
            this.queueFull();
        }
        this.queue[this.rear] = target;
    }

    public void addFront(Object target) {
        if ((this.rear + 1) % this.size == this.front) {
            this.queueFull();
        }
        this.queue[this.front] = target;
        --this.front;
        if (this.front < 0) {
            this.front = this.size - 1;
        }
    }

    public int getIndex(Object obj) {
        if (this.rear == this.front) {
            return -1;
        }
        if (this.rear > this.front) {
            for (int i = this.front + 1; i <= this.rear; ++i) {
                if (!obj.equals(this.queue[i])) continue;
                return i;
            }
        } else {
            int i;
            for (i = this.front + 1; i < this.size; ++i) {
                if (!obj.equals(this.queue[i])) continue;
                return i;
            }
            for (i = 0; i <= this.rear; ++i) {
                if (!obj.equals(this.queue[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean contains(Object obj) {
        return this.getIndex(obj) > -1;
    }

    public boolean deleteItems(int index) {
        if (this.rear > this.front) {
            if (index < this.rear && this.front < index) {
                this.front = index;
                return true;
            }
        } else if (index < this.size && (this.front < index || index < this.rear) && index > -1) {
            this.front = index;
            return true;
        }
        return false;
    }

    private void queueFull() {
        Object[] newQueue = new Object[2 * this.size];
        System.arraycopy(this.queue, this.front + 1, newQueue, 1, this.size - this.front - 1);
        System.arraycopy(this.queue, 0, newQueue, this.size - this.front, this.front);
        this.queue = newQueue;
        this.front = 0;
        this.rear = this.size;
        this.size *= 2;
    }

    public Object getFront() {
        if (this.front == this.rear) {
            return null;
        }
        this.front = (this.front + 1) % this.size;
        Object obj = this.queue[this.front];
        this.queue[this.front] = null;
        return obj;
    }

    public Object peekRear() {
        if (this.front == this.rear) {
            return null;
        }
        return this.queue[this.rear];
    }

    public Object peekFront() {
        if (this.front == this.rear) {
            return null;
        }
        return this.queue[(this.front + 1) % this.size];
    }

    public Object[] getAll() {
        Object[] allData;
        if (this.rear > this.front) {
            allData = new Object[this.rear - this.front];
            System.arraycopy(this.queue, this.front + 1, allData, 0, this.rear - this.front);
        } else if (this.front > this.rear) {
            allData = new Object[this.size - (this.front - this.rear)];
            System.arraycopy(this.queue, this.front + 1, allData, 0, this.size - this.front - 1);
            System.arraycopy(this.queue, 0, allData, this.size - this.front - 1, this.rear + 1);
        } else {
            return new Object[0];
        }
        this.front = 0;
        this.rear = 0;
        this.queue = new Object[this.size];
        return allData;
    }

    public Object[] browse() {
        Object[] allData;
        if (this.rear > this.front) {
            allData = new Object[this.rear - this.front];
            System.arraycopy(this.queue, this.front + 1, allData, 0, this.rear - this.front);
        } else if (this.front > this.rear) {
            allData = new Object[this.size - (this.front - this.rear)];
            System.arraycopy(this.queue, this.front + 1, allData, 0, this.size - this.front - 1);
            System.arraycopy(this.queue, 0, allData, this.size - this.front - 1, this.rear + 1);
        } else {
            return null;
        }
        return allData;
    }

    public int size() {
        if (this.rear == this.front) {
            return 0;
        }
        if (this.rear > this.front) {
            return this.rear - this.front;
        }
        return this.size - this.front + this.rear;
    }

    void printQueue() {
        int i;
        System.out.print("[Queue] queue : ");
        for (i = 0; i < this.size; ++i) {
            System.out.print(i + " ");
        }
        System.out.println("");
        System.out.print("[Queue] queue : ");
        for (i = 0; i < this.size; ++i) {
            System.out.print(this.queue[i] + " ");
        }
        System.out.println("");
    }

    public void clear() {
        this.front = 0;
        this.rear = 0;
        this.size = 10;
        this.queue = new Object[this.size];
    }
}

