/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.cnet;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;
import jeus.util.ByteUtil;
import jeus.util.JeusSocket;
import jeus.util.cnet.DestinationNotFoundException;
import jeus.util.cnet.SockPassConstants;

public class SocketProxy
implements SockPassConstants {
    public static Socket getConnection(String host, int port, String virtualPort, int timeout, boolean isJavaChannel) throws UnknownHostException, IOException, InterruptedIOException {
        return SocketProxy.getConnection(host, port, null, 0, virtualPort, timeout, isJavaChannel, null, 20000);
    }

    public static Socket getConnection(String host, int port, String virtualPort, int timeout, boolean isJavaChannel, int soTimeout) throws UnknownHostException, IOException, InterruptedIOException {
        return SocketProxy.getConnection(host, port, null, 0, virtualPort, timeout, isJavaChannel, null, soTimeout);
    }

    public static Socket getConnection(String host, int port, String localHost, int localPort, String virtualPort, int timeout, boolean isJavaChannel, int soTimeout) throws UnknownHostException, IOException, InterruptedIOException {
        return SocketProxy.getConnection(host, port, localHost, localPort, virtualPort, timeout, isJavaChannel, null, soTimeout);
    }

    private static Socket getConnection(String host, int port, String localHost, int localPort, String virtualPort, int timeout, boolean isJavaChannel, SSLContext sslContext, int soTimeout) throws UnknownHostException, IOException, InterruptedIOException {
        if (host.indexOf(":") >= 0) {
            Thread.dumpStack();
        }
        Socket socket = JeusSocket.getConnection(host, port, localHost, localPort, timeout, isJavaChannel, sslContext);
        int beforeSoTimeout = socket.getSoTimeout();
        socket.setSoTimeout(soTimeout);
        OutputStream out = socket.getOutputStream();
        byte[] buf = SocketProxy.makePacket((byte)100, virtualPort);
        out.write(buf);
        out.flush();
        InputStream in = socket.getInputStream();
        int status = in.read();
        switch (status) {
            case 1: {
                socket.setSoTimeout(beforeSoTimeout);
                return socket;
            }
            case 2: {
                SocketProxy.closeSocket(socket);
                throw new DestinationNotFoundException("destination not found. host = " + host + ", port = " + port + ", id = " + virtualPort);
            }
        }
        SocketProxy.closeSocket(socket);
        throw new IOException("connection failed. host = " + host + ", port = " + port + ", id = " + virtualPort);
    }

    private static void closeSocket(Socket socket) {
        try {
            socket.shutdownInput();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            socket.shutdownOutput();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte[] makePacket(byte opcode, String body) {
        byte[] bodybuf = body.getBytes();
        int bodylen = bodybuf.length;
        byte[] buf = new byte[12 + bodylen];
        System.arraycopy(MAGIC, 0, buf, 0, 7);
        buf[7] = opcode;
        ByteUtil.putInt(buf, 8, bodylen);
        System.arraycopy(bodybuf, 0, buf, 12, bodylen);
        return buf;
    }
}

