/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.concurrent;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ConcurrentHashSetIterator
extends HashSet {
    private Object[] values;

    public ConcurrentHashSetIterator() {
    }

    public ConcurrentHashSetIterator(HashSet _hashSet) {
        super(_hashSet);
    }

    public Iterator iterator() {
        return new ReadOnlyIterator(this.getValues());
    }

    public synchronized boolean add(Object o) {
        this.values = null;
        return super.add(o);
    }

    public synchronized boolean remove(Object o) {
        this.values = null;
        return super.remove(o);
    }

    public synchronized boolean removeAll(Collection c) {
        this.values = null;
        return super.removeAll(c);
    }

    public synchronized boolean addAll(Collection c) {
        this.values = null;
        return super.addAll(c);
    }

    public synchronized boolean retainAll(Collection c) {
        this.values = null;
        return super.retainAll(c);
    }

    public synchronized boolean contains(Object o) {
        return super.contains(o);
    }

    public synchronized boolean containsAll(Collection c) {
        return super.containsAll(c);
    }

    public synchronized int size() {
        return super.size();
    }

    public synchronized void clear() {
        this.values = null;
        super.clear();
    }

    public synchronized boolean isEmpty() {
        return super.isEmpty();
    }

    public synchronized Object[] toArray() {
        return super.toArray();
    }

    public synchronized Object[] toArray(Object[] a) {
        return super.toArray(a);
    }

    public synchronized Object clone() {
        return new ConcurrentHashSetIterator(this);
    }

    private synchronized Object[] getValues() {
        if (this.values == null) {
            this.values = new Object[this.size()];
            Iterator it = super.iterator();
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = it.next();
            }
        }
        return this.values;
    }

    private class ReadOnlyIterator
    implements Iterator {
        private int index;
        private Object[] values;

        public ReadOnlyIterator(Object[] values) {
            this.values = values;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.index < this.values.length;
        }

        public Object next() {
            if (this.index >= this.values.length) {
                throw new NoSuchElementException();
            }
            return this.values[this.index++];
        }
    }
}

