/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.concurrent50.concurrent.helpers;

public class ThreadHelpers {
    private ThreadHelpers() {
    }

    public static Runnable assignExceptionHandler(final Runnable runnable, final UncaughtExceptionHandler handler) {
        if (runnable == null || handler == null) {
            throw new NullPointerException();
        }
        return new Runnable(){

            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable error) {
                    try {
                        handler.uncaughtException(Thread.currentThread(), error);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        };
    }

    public static interface UncaughtExceptionHandler {
        public void uncaughtException(Thread var1, Throwable var2);
    }
}

