/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.logging.LogRecord;
import jeus.util.StringUtil;
import jeus.util.logging.ErrorLogRecord;
import jeus.util.logging.SimpleFormatter;

public class CommanderFormatter
extends SimpleFormatter {
    private static String FORMATTER_ID_PREFIX = "JEUS_COMMANDER_FORMATTER";

    public synchronized String format(LogRecord r) {
        if (r instanceof ErrorLogRecord) {
            ErrorLogRecord record = (ErrorLogRecord)r;
            String formattedMessage = record.getFormattedMessage(this.FORMATTER_ID);
            if (formattedMessage != null) {
                return formattedMessage;
            }
            StringBuffer text = new StringBuffer();
            String message = record.getLocalizedString();
            text.append(message);
            text.append(lineSeparator);
            if (record.getThrown() != null) {
                try {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    text.append("<<__Exception__>>").append(StringUtil.lineSeparator);
                    CommanderFormatter.printStackTraces(record.getThrown(), pw);
                    pw.close();
                    text.append(sw.toString());
                    text.append("<<__!Exception__>>").append(StringUtil.lineSeparator);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            formattedMessage = text.toString();
            record.setFormattedMessage(this.FORMATTER_ID, formattedMessage);
            return formattedMessage;
        }
        StringBuffer text = new StringBuffer();
        String message = this.formatMessage(r);
        text.append(message);
        text.append(lineSeparator);
        if (r.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                CommanderFormatter.printStackTraces(r.getThrown(), pw);
                pw.close();
                text.append(sw.toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return text.toString();
    }

    public void setProperty(Map propertyMap) {
        this.propertyMap = propertyMap;
        this.FORMATTER_ID = FORMATTER_ID_PREFIX;
    }
}

