/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.logging;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import javax.naming.Reference;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogRecord;

public class ErrorLogRecord
extends JeusLogRecord {
    private String localizedMessage;
    private transient ErrorMsgManager.ErrorMessage2 messageObject;
    private String jvmId = JVM_ID;
    private String formattedMessage;
    public static final int DUMMY_MESSAGE_NUMBER = -1;
    private static final String DUMMY_SOURCE_MODULE_NAME = "";
    private static final ErrorMsgManager.ErrorMessage2 DUMMY_MESSAGE_OBJECT = new ErrorMsgManager.ErrorMessage2("", -1);
    private String subject;
    private String appName;
    public static final String[] parameters = new String[]{"level", "message", "threadID", "appName", "jvmId", "messageNumber", "sourceModuleName"};

    public ErrorLogRecord(int msgNum) {
        this(ErrorMsgManager.getLevel(msgNum), msgNum);
    }

    public ErrorLogRecord(Level level, int msgNum) {
        super(level, ErrorMsgManager.getRawString(msgNum));
        this.messageObject = ErrorMsgManager.getErrMessage(msgNum);
    }

    public ErrorLogRecord(Level level, String subject, String msg) {
        super(level, msg);
        this.subject = subject;
        this.messageObject = DUMMY_MESSAGE_OBJECT;
    }

    public ErrorLogRecord(String sourceModule, int number, String jvmId, int threadId, Date dat, Level level, String message, String appName, String loggerName) {
        super(level, message);
        this.messageObject = new ErrorMsgManager.ErrorMessage2(sourceModule, number);
        this.jvmId = jvmId;
        this.setThreadID(threadId);
        this.setMillis(dat.getTime());
        this.appName = appName;
        this.setLoggerName(loggerName);
    }

    public Map getLogInfo() {
        Map map = super.getLogInfo();
        map.put("jvmId", this.jvmId);
        map.put("sourceModuleName", this.getSourceModuleName());
        map.put("messageNumber", new Integer(this.getMessageNumber()));
        map.put("appName", this.appName);
        return map;
    }

    public String getSourceModuleName() {
        return this.messageObject.getSourceModuleName();
    }

    public int getMessageNumber() {
        return this.messageObject.getMessageNumber();
    }

    public String getMessage() {
        return this.getLocalizedString();
    }

    public String getLocalizedString() {
        if (this.localizedMessage == null) {
            Object[] params = this.getParameters();
            String rawMessage = super.getMessage();
            if (params == null) {
                this.localizedMessage = rawMessage;
                return rawMessage;
            }
            Object[] stringParams = new String[params.length];
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null) {
                    stringParams[i] = "null";
                    continue;
                }
                if (params[i] instanceof Reference) {
                    Reference ref = (Reference)params[i];
                    stringParams[i] = ref.getClassName();
                    continue;
                }
                stringParams[i] = params[i].toString();
            }
            this.localizedMessage = new String(this.messageObject.getErrorString(stringParams));
        }
        return this.localizedMessage;
    }

    public String getFormattedMessage(String formatter_id) {
        return this.formattedMessage;
    }

    public void setFormattedMessage(String formatter_id, String formattedMessage) {
        this.formattedMessage = formattedMessage;
    }

    public String getJvmId() {
        return this.jvmId;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String name) {
        this.appName = name;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeUTF(this.getSourceModuleName());
        s.writeInt(this.getMessageNumber());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        String moduleName = s.readUTF();
        int number = s.readInt();
        this.messageObject = new ErrorMsgManager.ErrorMessage2(moduleName, number);
    }
}

