/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.logging;

import java.util.StringTokenizer;
import jeus.util.logging.PrintfFormat;

public class HexDumpUtility {
    private static final String CHAR_SET = "0123456789abcdef";
    private static final byte[] RGB_DIGITS = "0123456789abcdef".getBytes();
    private static final int PRINT_BUFFER_SIZE = 100;
    private static final String HEX_DELIM = " .;:\r\n\t";
    private static final PrintfFormat formatter = new PrintfFormat("0x%4.4x  ");

    public static String getAsciiDump(byte[] bytes) {
        return HexDumpUtility.getAsciiDump(bytes, 0, bytes.length);
    }

    public static String getAsciiDump(byte[] bytes, int length) {
        return HexDumpUtility.getAsciiDump(bytes, 0, length);
    }

    public static String getAsciiDump(byte[] bytes, int startOffset, int length) {
        if (bytes == null) {
            return "";
        }
        int count = 0;
        int index = 0;
        int offset = 0;
        int i = 0;
        int cbLine = 0;
        char[] rgbLine = new char[100];
        StringBuffer stringBuffer = new StringBuffer();
        if (startOffset > bytes.length || startOffset < 0) {
            startOffset = 0;
        }
        offset = startOffset;
        if (bytes.length - startOffset < length || length < 0) {
            length = bytes.length - startOffset;
        }
        index = 0;
        while (length > 0) {
            String indexString = formatter.sprintf(index);
            System.arraycopy(indexString.toCharArray(), 0, rgbLine, 0, indexString.length());
            cbLine = indexString.length();
            count = length > 16 ? 16 : length;
            for (i = 0; i < count; ++i) {
                rgbLine[cbLine++] = (char)RGB_DIGITS[(bytes[i + offset] & 0xFF) >> 4];
                rgbLine[cbLine++] = (char)RGB_DIGITS[bytes[i + offset] & 0xF];
                rgbLine[cbLine++] = i == 7 ? 58 : 32;
            }
            while (i < 16) {
                rgbLine[cbLine++] = 32;
                rgbLine[cbLine++] = 32;
                rgbLine[cbLine++] = 32;
                ++i;
            }
            rgbLine[cbLine++] = 32;
            for (i = 0; i < count; ++i) {
                rgbLine[cbLine++] = bytes[i + offset] < 32 || bytes[i + offset] > 126 ? 46 : (char)bytes[i + offset];
            }
            rgbLine[cbLine] = '\u0000';
            stringBuffer.append(rgbLine, 0, cbLine).append('\n');
            length -= count;
            offset += count;
            index += count;
        }
        return stringBuffer.toString();
    }

    public static String getAsciiDumpFromHex(String hexString) {
        if (hexString == null) {
            return "";
        }
        StringTokenizer tokenizer = new StringTokenizer(hexString, HEX_DELIM);
        byte[] bytes = new byte[hexString.length()];
        int count = 0;
        int hex = 0;
        while (tokenizer.hasMoreTokens()) {
            try {
                hex = Integer.parseInt(tokenizer.nextToken(), 16);
            }
            catch (NumberFormatException e) {
                hex = 0;
            }
            bytes[count++] = (byte)hex;
        }
        return HexDumpUtility.getAsciiDump(bytes, count);
    }

    public static void main(String[] args) {
        String test = "asdfkjh1234j12379`74~!@$~@%~!@%~@#4l23!@#!$";
        System.out.println(HexDumpUtility.getAsciiDump(test.getBytes(), test.length()));
        System.out.println(HexDumpUtility.getAsciiDump(test.getBytes(), 5, test.length()));
        String test2 = "612@ \n \t   73 64 66 6b 6A 68 31:32 33 34 6a 31 32 33 37 39 60 37 34 7e 21 40 24:7e 40 25 7e 21 40 25 7e 40 23 34 6c 32 33 21 40:23 21 24";
        System.out.println(HexDumpUtility.getAsciiDumpFromHex(test2));
    }
}

