/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.logging;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import jeus.util.JeusOutputStreamWriter;
import jeus.util.logging.JeusHandler;
import jeus.util.properties.JeusLoggerProperties;

public abstract class StreamHandler
extends JeusHandler {
    private OutputStream output;
    private boolean doneHeader;
    private Writer writer;
    private int bufferSize;

    public StreamHandler() {
    }

    public StreamHandler(OutputStream out, Formatter formatter, int bufferSize) {
        this.setFormatter(formatter);
        this.setOutputStream(out, bufferSize);
    }

    protected synchronized void setOutputStream(OutputStream out, int bufferSize) throws SecurityException {
        if (out == null) {
            throw new NullPointerException();
        }
        this.flushAndClose();
        this.output = out;
        this.doneHeader = false;
        String encoding = this.getEncoding();
        this.bufferSize = bufferSize;
        this.writer = encoding == null ? new JeusOutputStreamWriter(this.output, bufferSize) : new JeusOutputStreamWriter(this.output, encoding, bufferSize);
    }

    public void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        super.setEncoding(encoding);
        if (this.output == null) {
            return;
        }
        this.flush();
        this.writer = encoding == null ? new JeusOutputStreamWriter(this.output, this.bufferSize) : new JeusOutputStreamWriter(this.output, encoding, this.bufferSize);
    }

    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        this.writeRecord(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeRecord(LogRecord record) {
        String msg;
        try {
            msg = this.getFormatter().format(record);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 5);
            return;
        }
        try {
            StreamHandler ex = this;
            synchronized (ex) {
                if (this.writer != null) {
                    if (!this.doneHeader) {
                        this.writer.write(this.getFormatter().getHead(this));
                        this.doneHeader = true;
                    }
                    this.writer.write(msg);
                }
            }
        }
        catch (Exception ex) {
            this.reportError(null, ex, 1);
        }
    }

    public boolean isLoggable(LogRecord record) {
        if (this.writer == null) {
            return false;
        }
        return super.isLoggable(record);
    }

    public synchronized void flush() {
        if (this.writer != null) {
            try {
                this.writer.flush();
            }
            catch (Exception ex) {
                this.reportError(null, ex, 2);
            }
        }
    }

    protected synchronized void flushAndClose() throws SecurityException {
        if (this.writer != null) {
            try {
                if (!this.doneHeader) {
                    this.writer.write(this.getFormatter().getHead(this));
                    this.doneHeader = true;
                }
                this.writer.write(this.getFormatter().getTail(this));
                this.writer.flush();
                this.writer.close();
            }
            catch (Exception ex) {
                this.reportError(null, ex, 3);
            }
            this.writer = null;
            this.output = null;
        }
    }

    public synchronized void close() throws SecurityException {
        if (JeusLoggerProperties.DEBUG_HANDLER_CLOSE) {
            LogRecord record = new LogRecord(Level.SEVERE, "close console handler");
            record.setThrown(new Exception("For close handler stack trace"));
            this.publish(record);
        }
        this.flushAndClose();
    }

    public PrintWriter getPrintWriter() {
        return new PrintWriter(this.writer);
    }
}

