/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.logging;

import java.nio.ByteBuffer;

public class Utility {
    private static final int DUMP_MAX = 256;

    public static String getDump(byte[] bytes) {
        return Utility.getDump(bytes, 0, bytes.length, " ", "\n");
    }

    public static String getDump(byte[] bytes, int length) {
        return Utility.getDump(bytes, 0, length, " ", "\n");
    }

    public static String getDump(byte[] bytes, int offset, int length) {
        return Utility.getDump(bytes, offset, length, " ", "\n");
    }

    public static String getDumpWoSpace(byte[] bytes, int offset, int length) {
        return Utility.getDump(bytes, offset, length, "", "\n");
    }

    public static String getDumpWoSpace(byte[] bytes) {
        return Utility.getDump(bytes, 0, bytes.length, "", "\n");
    }

    public static String getDump(byte[] bytes, int offset, int length, String separator, String lineSeparator) {
        StringBuffer buf = new StringBuffer();
        for (int i = offset; i < Math.min(bytes.length, offset + length); ++i) {
            String str = Integer.toHexString(bytes[i] & 0xFF);
            buf.append(str.length() == 1 ? "0" : "").append(str).append(separator);
            if ((i - offset) % 32 != 31) continue;
            buf.append(lineSeparator);
        }
        return buf.toString();
    }

    public static byte[] getBytes(String dumpString) {
        if (dumpString == null) {
            return null;
        }
        int stringLen = dumpString.length();
        if (stringLen % 2 != 0) {
            return null;
        }
        byte[] bytes = new byte[stringLen / 2];
        int byteIndex = 0;
        for (int i = 0; i < stringLen / 2; ++i) {
            String byteString = dumpString.substring(byteIndex, byteIndex + 2);
            try {
                bytes[i] = (byte)(Integer.valueOf(byteString, 16) & 0xFF);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            byteIndex += 2;
        }
        return bytes;
    }

    public static String getDump(ByteBuffer[] buffer) {
        StringBuffer buf = new StringBuffer();
        int index = 0;
        for (int j = 0; j < buffer.length; ++j) {
            int i = 0;
            while (i < buffer[j].limit()) {
                String str = Integer.toHexString(buffer[j].get(i) & 0xFF);
                buf.append(str.length() == 1 ? "0" : "").append(str).append(" ");
                if (index >= 256) {
                    return buf.toString();
                }
                if (index % 32 == 31) {
                    buf.append("\n");
                }
                ++i;
                ++index;
            }
        }
        return buf.toString();
    }

    public static String getDump(ByteBuffer buffer, int limit) {
        return Utility.getDump(buffer, 0, limit);
    }

    public static String getDump(ByteBuffer buffer, int offset, int limit) {
        limit = Math.min(offset + 256, limit);
        StringBuffer buf = new StringBuffer();
        for (int i = offset; i < limit; ++i) {
            String str = Integer.toHexString(buffer.get(i) & 0xFF);
            buf.append(str.length() == 1 ? "0" : "").append(str).append(' ');
            if (i == limit - 1 || (i - offset) % 32 != 31) continue;
            buf.append("\n");
        }
        return buf.toString();
    }

    public static String getAsciiDump(byte[] bytes, int offset, int length) {
        int i;
        StringBuffer buffer = new StringBuffer(256);
        StringBuffer ascii = new StringBuffer(16);
        int to = Math.min(length, 256);
        for (i = 0; i < to; ++i) {
            char c;
            byte b = bytes[i + offset];
            String value = Integer.toHexString(b & 0xFF);
            if (value.length() == 1) {
                buffer.append('0');
            }
            if (Character.isDefined(c = (char)b)) {
                ascii.append(c);
            } else {
                ascii.append('-');
            }
            buffer.append(value).append(' ');
            if (i % 32 != 31) continue;
            buffer.append('\t').append(ascii.toString());
            ascii = new StringBuffer(16);
            if (i == to - 1) continue;
            buffer.append("\n");
        }
        for (i = 0; i < 32 - (to - 1) % 32; ++i) {
            buffer.append("   ");
        }
        buffer.append('\t').append(ascii.toString());
        return buffer.toString();
    }
}

