/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import jeus.util.DaemonThreadFactory;
import jeus.util.concurrent50.concurrent.Executor;
import jeus.util.concurrent50.concurrent.Executors;
import jeus.util.message.JeusMessage_Network;
import jeus.util.net.AbstractActiveDispatcher;
import jeus.util.net.DispatcherRequestHandler;
import jeus.util.net.JNBBuffer;
import jeus.util.net.SocketDispatcher;
import jeus.util.net.SocketDispatcherListener;

final class BlockingActiveDispatcher
extends AbstractActiveDispatcher {
    private Executor requestHandlerPool;
    private ServerSocketChannel serverSocketChannel;

    BlockingActiveDispatcher(Executor executor, int listenport, int backlog, boolean enableSSL, int sslPort, SocketDispatcherListener listener) throws IOException {
        super(executor, listenport, backlog, enableSSL, sslPort, listener);
    }

    protected void initSocket() throws IOException {
        this.requestHandlerPool = Executors.newCachedThreadPool(new DaemonThreadFactory("BlockingActiveDispatcher", true));
        this.serverSocketChannel = ServerSocketChannel.open();
        this.serverSocketChannel.configureBlocking(true);
        ServerSocket serverSocket = this.serverSocketChannel.socket();
        InetSocketAddress localAddr = new InetSocketAddress(this.listenport);
        serverSocket.bind(localAddr, this.backlog);
        if (logger.isLoggable(JeusMessage_Network._1005_LEVEL)) {
            logger.log(JeusMessage_Network._1005_LEVEL, JeusMessage_Network._1005, (Object)Integer.toString(this.listenport));
        }
    }

    protected void destroyInternal() {
        try {
            this.serverSocketChannel.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run() {
        while (this.running) {
            try {
                SocketChannel sc = this.serverSocketChannel.accept();
                sc.configureBlocking(true);
                if (!this.running) break;
                this.requestHandlerPool.execute(new RequestHandler(sc));
            }
            catch (IOException ioe) {
                if (!this.running) continue;
                ioe.printStackTrace();
                this.listener.failover(ioe, this);
            }
        }
    }

    public Executor getExecutor() {
        return null;
    }

    public String getDispatcherName() {
        return "<BlockingActiveDispatcher>";
    }

    void removeListenerById(Object[] id, JNBBuffer buffer) {
        this.receiverTable.unregister(id, buffer);
    }

    public int getPort() {
        return this.serverSocketChannel.socket().getLocalPort();
    }

    public String getHostAddress() {
        return this.serverSocketChannel.socket().getInetAddress().getHostAddress();
    }

    private class RequestHandler
    implements Runnable {
        private SocketChannel channel = null;
        boolean handler_running = true;

        public RequestHandler(SocketChannel sc) {
            this.channel = sc;
        }

        public void run() {
            JNBBuffer buf = new JNBBuffer(this.channel, BlockingActiveDispatcher.this);
            while (this.handler_running && BlockingActiveDispatcher.this.running) {
                boolean ready = false;
                try {
                    ready = buf.readData();
                }
                catch (IOException ioe) {
                    if (buf.getId().size() > 0 && SocketDispatcher.logger.isLoggable(JeusMessage_Network._1008_LEVEL)) {
                        SocketDispatcher.logger.log(JeusMessage_Network._1008_LEVEL, JeusMessage_Network._1008, buf.getSocketChannel(), (Throwable)ioe);
                    }
                    buf.destroy();
                    this.handler_running = false;
                }
                if (!ready) continue;
                try {
                    this.handleRequest(buf);
                }
                catch (IOException ioe) {
                    if (SocketDispatcher.logger.isLoggable(JeusMessage_Network._1007_LEVEL)) {
                        SocketDispatcher.logger.log(JeusMessage_Network._1007_LEVEL, JeusMessage_Network._1007, this.channel, (Throwable)ioe);
                    }
                    buf.destroy();
                    this.handler_running = false;
                    try {
                        this.channel.close();
                    }
                    catch (IOException ie) {
                        ie.printStackTrace();
                    }
                }
                buf.reset();
                buf.setSocketChannel(this.channel);
            }
        }

        private void handleRequest(JNBBuffer buf) throws IOException {
            int opcode = buf.getOpcode();
            DispatcherRequestHandler handler = BlockingActiveDispatcher.this.handlerFactory.getHandler(opcode);
            if (handler == null) {
                if (SocketDispatcher.logger.isLoggable(JeusMessage_Network._1006_LEVEL)) {
                    SocketDispatcher.logger.log(JeusMessage_Network._1006_LEVEL, JeusMessage_Network._1006, (Object)Integer.toHexString(opcode));
                }
                return;
            }
            handler.handleRequest(buf);
            if (opcode == 100) {
                this.handler_running = false;
            }
        }
    }
}

