/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import jeus.util.CUtility;
import jeus.util.net.TestConstant;

public class TestClient
implements TestConstant {
    private int port;
    private String hid;
    private Socket socket;
    private DataOutputStream out;
    private DataInputStream in;
    private int mypid;

    public TestClient(int port, String hid) {
        this.port = port;
        this.hid = hid;
        this.mypid = CUtility.thisProcessPID;
    }

    public void connect() throws Exception {
        this.socket = new Socket("yskim3", this.port);
        this.out = new DataOutputStream(this.socket.getOutputStream());
        this.in = new DataInputStream(this.socket.getInputStream());
        this.out.writeInt(66595);
        this.out.writeInt(1);
        this.out.writeInt(this.mypid);
        int tlen = 0;
        int fcount = 1;
        byte[] frag = this.hid.getBytes();
        int flen = frag.length;
        tlen = 12 + flen;
        this.out.writeInt(tlen);
        this.out.writeInt(fcount);
        this.out.writeInt(flen);
        this.out.write(frag);
        this.out.flush();
    }

    public void doRequest(String msg) throws IOException {
        this.out.writeInt(66595);
        this.out.writeInt(3);
        this.out.writeInt(this.mypid);
        int tlen = 0;
        int fcount = 1;
        byte[] frag = msg.getBytes();
        int flen = frag.length;
        tlen = 12 + flen;
        this.out.writeInt(tlen);
        this.out.writeInt(fcount);
        this.out.writeInt(flen);
        this.out.write(frag);
        this.out.flush();
        int magic = this.in.readInt();
        if (magic != 66595) {
            this.close();
            throw new IOException("magic error : " + magic);
        }
        int opcode = this.in.readInt();
        if (opcode != 5) {
            this.close();
            throw new IOException("unknown opcode : " + opcode);
        }
        int len = this.in.readInt();
        len = this.in.readInt();
        this.in.readInt();
        if (len <= 0) {
            this.close();
            throw new IOException("invalid length : " + len);
        }
        byte[] buf = new byte[len];
        this.in.readFully(buf);
        System.out.println("SVRRPLY : " + new String(buf));
    }

    public void close() throws IOException {
        this.in.close();
        this.out.close();
        this.socket.close();
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length < 1) {
            System.out.println("Usage : TestClient [port] handlerId");
            System.exit(1);
        }
        int port = 8888;
        String hid = null;
        if (argv.length > 1) {
            try {
                port = Integer.parseInt(argv[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
            hid = argv[1];
        } else {
            hid = argv[0];
        }
        TestClient client = new TestClient(port, hid);
        client.connect();
        System.out.println("waiting 30 sec");
        Thread.sleep(30000L);
        for (int i = 0; i < 10; ++i) {
            client.doRequest("test message " + i);
            Thread.sleep(1000L);
        }
        client.close();
    }
}

