/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.properties;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import jeus.util.properties.JeusNetProperties;

public class JeusNetPropertyValues {
    public static final String LOCAL_LOOPBACK_ADDRESS = "127.0.0.1";
    public static final String LOCAL_HOSTNAME;
    public static final String LOCAL_FULL_HOSTNAME;
    public static final String LOCAL_HOSTADDRESS;
    private static final InetAddress LOCAL_INETADDRESS;

    public static void printNetworkConfiguration() {
        System.out.println("[Network Configuration] default local hostname : " + JeusNetProperties.DEFAULT_LOCAL_HOSTNAME + ", default local ip : " + JeusNetProperties.DEFAULT_LOCAL_IP + ", local inetaddress : " + LOCAL_INETADDRESS + ", local host address : " + LOCAL_HOSTADDRESS + ", full host name : " + LOCAL_FULL_HOSTNAME + ", local hostname : " + LOCAL_HOSTNAME);
    }

    private static boolean isAddressMatch(InetAddress inetAddress) {
        boolean result;
        String localAddress = inetAddress.getHostAddress();
        String hostName = inetAddress.getHostName();
        boolean bl = result = JeusNetProperties.DEFAULT_LOCAL_IP == null || JeusNetProperties.DEFAULT_LOCAL_IP.equals(localAddress);
        if (result && JeusNetProperties.DEFAULT_LOCAL_HOSTNAME != null && !JeusNetProperties.DEFAULT_LOCAL_HOSTNAME.equals(hostName)) {
            System.out.println("[WARNING] The local IP is matched to the specified IP, but not for the host name, specified host name : " + JeusNetProperties.DEFAULT_LOCAL_HOSTNAME + ", the host name of the IP : " + hostName);
        }
        return result;
    }

    public static InetAddress getLocalInetAddress() {
        return LOCAL_INETADDRESS;
    }

    public static InetAddress getByName(String host) throws UnknownHostException {
        if (host.equals(LOCAL_FULL_HOSTNAME) || host.equals("localhost")) {
            return LOCAL_INETADDRESS;
        }
        return InetAddress.getByName(host);
    }

    static {
        InetAddress selectedAddress = null;
        try {
            InetAddress address = InetAddress.getLocalHost();
            if (JeusNetPropertyValues.isAddressMatch(address)) {
                selectedAddress = address;
            }
        }
        catch (UnknownHostException e) {
            System.out.println("[NetworkConfiguration] Fail to execute getLocalHost()");
        }
        if (selectedAddress == null) {
            String detectedIP = "";
            InetAddress loopbackAddress = null;
            try {
                Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
                block4: while (e.hasMoreElements()) {
                    NetworkInterface ni = e.nextElement();
                    Enumeration<InetAddress> e1 = ni.getInetAddresses();
                    while (e1.hasMoreElements()) {
                        InetAddress inetAddress = e1.nextElement();
                        if (!inetAddress.isLoopbackAddress()) {
                            if (JeusNetProperties.DEFAULT_LOCAL_IP == null && JeusNetProperties.DEFAULT_LOCAL_HOSTNAME == null) {
                                selectedAddress = inetAddress;
                                continue block4;
                            }
                            if (JeusNetPropertyValues.isAddressMatch(inetAddress)) {
                                selectedAddress = inetAddress;
                                continue block4;
                            }
                            String localAddress = inetAddress.getHostAddress();
                            String hostName = inetAddress.getHostName();
                            detectedIP = detectedIP + hostName + "/" + localAddress + ",";
                            continue;
                        }
                        loopbackAddress = inetAddress;
                    }
                }
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
            if (selectedAddress == null) {
                if (loopbackAddress != null && JeusNetPropertyValues.isAddressMatch(loopbackAddress)) {
                    selectedAddress = loopbackAddress;
                } else {
                    throw new RuntimeException("No match local IP address : " + JeusNetProperties.DEFAULT_LOCAL_IP + ", detected ip : " + detectedIP);
                }
            }
        }
        String localHostName = JeusNetProperties.DEFAULT_LOCAL_HOSTNAME != null ? JeusNetProperties.DEFAULT_LOCAL_HOSTNAME : selectedAddress.getHostName();
        LOCAL_INETADDRESS = selectedAddress;
        LOCAL_HOSTADDRESS = selectedAddress.getHostAddress();
        LOCAL_FULL_HOSTNAME = localHostName;
        LOCAL_HOSTNAME = localHostName.indexOf(46) != -1 ? localHostName.substring(0, localHostName.indexOf(46)) : localHostName;
    }
}

