/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.reader;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.parser.ASTIdentifier;
import org.apache.commons.jexl.parser.ASTReference;
import org.apache.commons.jexl.parser.Node;
import org.apache.commons.jexl.parser.Parser;
import org.apache.commons.jexl.parser.SimpleNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExpressionCollectionParser {
    protected final Log log = LogFactory.getLog(this.getClass());
    public static final String COLLECTION_REFERENCE_SUFFIX = "_JxLsC_";
    private static ThreadLocal parser = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new Parser((Reader)new StringReader(";"));
        }
    };
    private boolean jexlInnerCollectionsAccess;
    private String collectionExpression;
    private Collection collection;

    public ExpressionCollectionParser(JexlContext jexlContext, String expr, boolean jexlInnerCollectionsAccess) {
        try {
            this.jexlInnerCollectionsAccess = jexlInnerCollectionsAccess;
            SimpleNode tree = ((Parser)parser.get()).parse((Reader)new StringReader(expr));
            ArrayList references = new ArrayList();
            this.findReferences(references, (Node)tree);
            this.findCollection(jexlContext, references);
        }
        catch (Exception e) {
            this.log.error((Object)("Can't parse jexl expression " + expr));
            throw new RuntimeException("Can't parse jexl expression", e);
        }
    }

    public String getCollectionExpression() {
        return this.collectionExpression;
    }

    public Collection getCollection() {
        return this.collection;
    }

    private void findReferences(List references, Node node) {
        if (node instanceof ASTReference) {
            references.add(node);
        }
        int childCount = node.jjtGetNumChildren();
        for (int i = 0; i < childCount; ++i) {
            this.findReferences(references, node.jjtGetChild(i));
        }
    }

    private void findCollection(JexlContext jexlContext, List references) {
        Iterator itr = references.iterator();
        while (itr.hasNext()) {
            Node node = (Node)itr.next();
            String collectionExpression = this.findCollectionProperties(jexlContext, node);
            if (collectionExpression == null) continue;
            if (collectionExpression.endsWith(COLLECTION_REFERENCE_SUFFIX)) break;
            this.collectionExpression = collectionExpression;
            break;
        }
    }

    private String findCollectionProperties(JexlContext jexlContext, Node node) {
        int childCount = node.jjtGetNumChildren();
        String subExpr = null;
        for (int i = 0; i < childCount; ++i) {
            Node child = node.jjtGetChild(i);
            if (!(child instanceof ASTIdentifier)) continue;
            ASTIdentifier ident = (ASTIdentifier)child;
            subExpr = subExpr == null ? ident.getIdentifierString() : subExpr + "." + ident.getIdentifierString();
            if (this.jexlInnerCollectionsAccess && subExpr.endsWith(COLLECTION_REFERENCE_SUFFIX)) {
                return subExpr;
            }
            try {
                Expression e = ExpressionFactory.createExpression((String)subExpr);
                Object obj = e.evaluate(jexlContext);
                if (!(obj instanceof Collection)) continue;
                this.collection = (Collection)obj;
                return subExpr;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

