/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.ABSerialize;
import Altibase.jdbc.driver.cmb;
import Altibase.jdbc.driver.cmp;
import Altibase.jdbc.driver.ex;
import java.nio.ByteBuffer;
import java.sql.SQLException;

public class BitSet
extends java.util.BitSet
implements ABSerialize {
    static final long serialVersionUID = 3354354352423523647L;
    private int precision = 0;

    public BitSet(int nbits) {
        super(nbits);
        this.precision = 0;
    }

    public BitSet(String v) throws SQLException {
        super(v.length());
        this.set(v);
    }

    final boolean isNull() {
        return this.precision == 0;
    }

    public void read(cmp chn) throws SQLException {
        cmb cbr = chn.remain();
        int precision = cbr.intValue();
        ByteBuffer bb = chn.getTmpBuffer(precision + 7 >>> 3);
        chn.get(bb);
        this.set(bb.array(), 0, bb.limit(), precision);
    }

    public void in_read(cmp chn) throws SQLException {
        cmb cbr = chn.remain();
        int precision = cbr.intValue();
        ByteBuffer bb = chn.getTmpBuffer(precision + 7 >>> 3);
        chn.in_get(bb);
        this.set(bb.array(), 0, bb.limit(), precision);
    }

    final void set(byte[] v) throws SQLException {
        if (v == null) {
            super.clear();
        } else {
            this.set(v, 0, v.length, v.length * 8);
        }
    }

    final void set(byte[] v, int from, int to, int prc) throws SQLException {
        super.clear();
        int i = 0;
        byte b = v[from];
        while (to > from) {
            for (int mask = 128; mask != 0; mask >>>= 1) {
                super.set(i, (b & mask) != 0);
                if (++i != prc) continue;
                this.precision = prc;
                return;
            }
            b = v[++from];
        }
        this.precision = prc;
    }

    public final void set(java.util.BitSet v, int scale) throws SQLException {
        super.clear();
        ex.test(scale > v.size(), (short)45);
        if (v != null) {
            super.or(v);
        }
        this.precision = scale;
    }

    public final void set(String v) throws SQLException {
        int precision = v.length();
        super.clear();
        block4: for (int i = 0; i < precision; ++i) {
            switch (v.charAt(i)) {
                case '1': {
                    super.set(i);
                    continue block4;
                }
                case '0': {
                    super.clear(i);
                    continue block4;
                }
                default: {
                    super.clear();
                    ex.exception((short)42);
                }
            }
        }
        this.precision = precision;
    }

    public final void setNull() {
        super.clear();
    }

    public String toString() {
        if (this.precision > 0) {
            StringBuffer sb = new StringBuffer(this.precision);
            for (int i = 0; i < this.precision; ++i) {
                sb.append(this.get(i) ? (char)'1' : '0');
            }
            return sb.toString();
        }
        return null;
    }

    public void write(cmp chn) throws SQLException {
        cmb cbw = chn.next();
        if (this.isNull()) {
            cbw.putByte((byte)1);
        } else {
            ByteBuffer bb = chn.getTmpBuffer(this.precision + 7 >>> 3);
            cbw.putByte((byte)19);
            cbw.putInt(this.precision);
            int i = 0;
            do {
                byte b = 0;
                for (int mask = 128; mask != 0; mask >>>= 1) {
                    if (super.get(i)) {
                        b = (byte)(b | mask);
                    }
                    if (i++ >= this.precision) break;
                }
                bb.put(b);
            } while (i < this.precision);
            bb.position(0);
            chn.putBuffer(bb);
        }
    }
}

