/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.objectidentity;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.security.acls.IdentityUnavailableException;
import org.springframework.security.acls.objectidentity.ObjectIdentity;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class ObjectIdentityImpl
implements ObjectIdentity {
    private Class javaType;
    private Serializable identifier;
    static /* synthetic */ Class class$java$io$Serializable;

    public ObjectIdentityImpl(String javaType, Serializable identifier) {
        Assert.hasText((String)javaType, (String)"Java Type required");
        Assert.notNull((Object)identifier, (String)"identifier required");
        try {
            this.javaType = Class.forName(javaType);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException((Exception)ex);
        }
        this.identifier = identifier;
    }

    public ObjectIdentityImpl(Class javaType, Serializable identifier) {
        Assert.notNull((Object)javaType, (String)"Java Type required");
        Assert.notNull((Object)identifier, (String)"identifier required");
        this.javaType = javaType;
        this.identifier = identifier;
    }

    public ObjectIdentityImpl(Object object) throws IdentityUnavailableException {
        Object result;
        Assert.notNull((Object)object, (String)"object cannot be null");
        this.javaType = ClassUtils.getUserClass(object.getClass());
        try {
            Method method = this.javaType.getMethod("getId", new Class[0]);
            result = method.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new IdentityUnavailableException("Could not extract identity from object " + object, e);
        }
        Assert.notNull((Object)result, (String)"getId() is required to return a non-null value");
        Assert.isInstanceOf((Class)(class$java$io$Serializable == null ? (class$java$io$Serializable = ObjectIdentityImpl.class$("java.io.Serializable")) : class$java$io$Serializable), (Object)result, (String)"Getter must provide a return value of type Serializable");
        this.identifier = (Serializable)result;
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (!(arg0 instanceof ObjectIdentityImpl)) {
            return false;
        }
        ObjectIdentityImpl other = (ObjectIdentityImpl)arg0;
        return this.getIdentifier().toString().equals(other.getIdentifier().toString()) && this.getJavaType().equals(other.getJavaType());
    }

    public Serializable getIdentifier() {
        return this.identifier;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public int hashCode() {
        int code = 31;
        code ^= this.javaType.hashCode();
        return code ^= this.identifier.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append("[");
        sb.append("Java Type: ").append(this.javaType.getName());
        sb.append("; Identifier: ").append(this.identifier).append("]");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

