/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.client.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.ws.FaultAwareWebServiceMessage;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.WebServiceIOException;
import org.springframework.ws.client.WebServiceTransformerException;
import org.springframework.ws.client.WebServiceTransportException;
import org.springframework.ws.client.core.FaultMessageResolver;
import org.springframework.ws.client.core.SourceExtractor;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.WebServiceMessageExtractor;
import org.springframework.ws.client.core.WebServiceOperations;
import org.springframework.ws.client.support.WebServiceAccessor;
import org.springframework.ws.client.support.destination.DestinationProvider;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.context.DefaultMessageContext;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.support.DefaultStrategiesHelper;
import org.springframework.ws.support.MarshallingUtils;
import org.springframework.ws.transport.FaultAwareWebServiceConnection;
import org.springframework.ws.transport.TransportException;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.WebServiceMessageSender;
import org.springframework.ws.transport.context.DefaultTransportContext;
import org.springframework.ws.transport.context.TransportContext;
import org.springframework.ws.transport.context.TransportContextHolder;
import org.springframework.ws.transport.support.TransportUtils;

public class WebServiceTemplate
extends WebServiceAccessor
implements WebServiceOperations {
    public static final String MESSAGE_TRACING_LOG_CATEGORY = "org.springframework.ws.client.MessageTracing";
    protected static final Log sentMessageTracingLogger = LogFactory.getLog((String)"org.springframework.ws.client.MessageTracing.sent");
    protected static final Log receivedMessageTracingLogger = LogFactory.getLog((String)"org.springframework.ws.client.MessageTracing.received");
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;
    private FaultMessageResolver faultMessageResolver;
    private boolean checkConnectionForError = true;
    private boolean checkConnectionForFault = true;
    private ClientInterceptor[] interceptors;
    private DestinationProvider destinationProvider;

    public WebServiceTemplate() {
        this.initDefaultStrategies();
    }

    public WebServiceTemplate(WebServiceMessageFactory messageFactory) {
        this.setMessageFactory(messageFactory);
        this.initDefaultStrategies();
    }

    public String getDefaultUri() {
        if (this.destinationProvider != null) {
            URI uri = this.destinationProvider.getDestination();
            return uri != null ? uri.toString() : null;
        }
        return null;
    }

    public void setDefaultUri(final String uri) {
        this.destinationProvider = new DestinationProvider(){

            public URI getDestination() {
                return URI.create(uri);
            }
        };
    }

    public DestinationProvider getDestinationProvider() {
        return this.destinationProvider;
    }

    public void setDestinationProvider(DestinationProvider destinationProvider) {
        this.destinationProvider = destinationProvider;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public Unmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public FaultMessageResolver getFaultMessageResolver() {
        return this.faultMessageResolver;
    }

    public void setFaultMessageResolver(FaultMessageResolver faultMessageResolver) {
        this.faultMessageResolver = faultMessageResolver;
    }

    public void setCheckConnectionForError(boolean checkConnectionForError) {
        this.checkConnectionForError = checkConnectionForError;
    }

    public void setCheckConnectionForFault(boolean checkConnectionForFault) {
        this.checkConnectionForFault = checkConnectionForFault;
    }

    public ClientInterceptor[] getInterceptors() {
        return this.interceptors;
    }

    public final void setInterceptors(ClientInterceptor[] interceptors) {
        this.interceptors = interceptors;
    }

    protected void initDefaultStrategies() {
        ClassPathResource resource = new ClassPathResource(ClassUtils.getShortName(this.getClass()) + ".properties", this.getClass());
        DefaultStrategiesHelper strategiesHelper = new DefaultStrategiesHelper((Resource)resource);
        if (this.getMessageFactory() == null) {
            this.initMessageFactory(strategiesHelper);
        }
        if (ObjectUtils.isEmpty((Object[])this.getMessageSenders())) {
            this.initMessageSenders(strategiesHelper);
        }
        if (this.getFaultMessageResolver() == null) {
            this.initFaultMessageResolver(strategiesHelper);
        }
    }

    private void initMessageFactory(DefaultStrategiesHelper helper) throws BeanInitializationException {
        WebServiceMessageFactory messageFactory = (WebServiceMessageFactory)helper.getDefaultStrategy(WebServiceMessageFactory.class);
        this.setMessageFactory(messageFactory);
    }

    private void initMessageSenders(DefaultStrategiesHelper helper) {
        List messageSenders = helper.getDefaultStrategies(WebServiceMessageSender.class);
        this.setMessageSenders(messageSenders.toArray(new WebServiceMessageSender[messageSenders.size()]));
    }

    private void initFaultMessageResolver(DefaultStrategiesHelper helper) throws BeanInitializationException {
        FaultMessageResolver faultMessageResolver = (FaultMessageResolver)helper.getDefaultStrategy(FaultMessageResolver.class);
        this.setFaultMessageResolver(faultMessageResolver);
    }

    public Object marshalSendAndReceive(Object requestPayload) {
        return this.marshalSendAndReceive(requestPayload, null);
    }

    public Object marshalSendAndReceive(String uri, Object requestPayload) {
        return this.marshalSendAndReceive(uri, requestPayload, null);
    }

    public Object marshalSendAndReceive(Object requestPayload, WebServiceMessageCallback requestCallback) {
        return this.marshalSendAndReceive(this.getDefaultUri(), requestPayload, requestCallback);
    }

    public Object marshalSendAndReceive(String uri, final Object requestPayload, final WebServiceMessageCallback requestCallback) {
        return this.sendAndReceive(uri, new WebServiceMessageCallback(){

            public void doWithMessage(WebServiceMessage request) throws IOException, TransformerException {
                if (requestPayload != null) {
                    Marshaller marshaller = WebServiceTemplate.this.getMarshaller();
                    if (marshaller == null) {
                        throw new IllegalStateException("No marshaller registered. Check configuration of WebServiceTemplate.");
                    }
                    MarshallingUtils.marshal(marshaller, requestPayload, request);
                    if (requestCallback != null) {
                        requestCallback.doWithMessage(request);
                    }
                }
            }
        }, new WebServiceMessageExtractor(){

            public Object extractData(WebServiceMessage response) throws IOException {
                Unmarshaller unmarshaller = WebServiceTemplate.this.getUnmarshaller();
                if (unmarshaller == null) {
                    throw new IllegalStateException("No unmarshaller registered. Check configuration of WebServiceTemplate.");
                }
                return MarshallingUtils.unmarshal(unmarshaller, response);
            }
        });
    }

    public boolean sendSourceAndReceiveToResult(Source requestPayload, Result responseResult) {
        return this.sendSourceAndReceiveToResult(requestPayload, null, responseResult);
    }

    public boolean sendSourceAndReceiveToResult(String uri, Source requestPayload, Result responseResult) {
        return this.sendSourceAndReceiveToResult(uri, requestPayload, null, responseResult);
    }

    public boolean sendSourceAndReceiveToResult(Source requestPayload, WebServiceMessageCallback requestCallback, Result responseResult) {
        return this.sendSourceAndReceiveToResult(this.getDefaultUri(), requestPayload, requestCallback, responseResult);
    }

    public boolean sendSourceAndReceiveToResult(String uri, Source requestPayload, WebServiceMessageCallback requestCallback, final Result responseResult) {
        try {
            final Transformer transformer = this.createTransformer();
            Boolean retVal = (Boolean)this.doSendAndReceive(uri, transformer, requestPayload, requestCallback, new SourceExtractor(){

                public Object extractData(Source source) throws IOException, TransformerException {
                    transformer.transform(source, responseResult);
                    return Boolean.TRUE;
                }
            });
            return retVal != null && retVal != false;
        }
        catch (TransformerConfigurationException ex) {
            throw new WebServiceTransformerException("Could not create transformer", ex);
        }
    }

    public Object sendSourceAndReceive(Source requestPayload, SourceExtractor responseExtractor) {
        return this.sendSourceAndReceive(requestPayload, null, responseExtractor);
    }

    public Object sendSourceAndReceive(String uri, Source requestPayload, SourceExtractor responseExtractor) {
        return this.sendSourceAndReceive(uri, requestPayload, null, responseExtractor);
    }

    public Object sendSourceAndReceive(Source requestPayload, WebServiceMessageCallback requestCallback, SourceExtractor responseExtractor) {
        return this.sendSourceAndReceive(this.getDefaultUri(), requestPayload, requestCallback, responseExtractor);
    }

    public Object sendSourceAndReceive(String uri, Source requestPayload, WebServiceMessageCallback requestCallback, SourceExtractor responseExtractor) {
        try {
            return this.doSendAndReceive(uri, this.createTransformer(), requestPayload, requestCallback, responseExtractor);
        }
        catch (TransformerConfigurationException ex) {
            throw new WebServiceTransformerException("Could not create transformer", ex);
        }
    }

    private Object doSendAndReceive(String uri, final Transformer transformer, final Source requestPayload, final WebServiceMessageCallback requestCallback, SourceExtractor responseExtractor) {
        Assert.notNull((Object)responseExtractor, (String)"responseExtractor must not be null");
        return this.sendAndReceive(uri, new WebServiceMessageCallback(){

            public void doWithMessage(WebServiceMessage message) throws IOException, TransformerException {
                transformer.transform(requestPayload, message.getPayloadResult());
                if (requestCallback != null) {
                    requestCallback.doWithMessage(message);
                }
            }
        }, new SourceExtractorMessageExtractor(responseExtractor));
    }

    public boolean sendAndReceive(WebServiceMessageCallback requestCallback, WebServiceMessageCallback responseCallback) {
        return this.sendAndReceive(this.getDefaultUri(), requestCallback, responseCallback);
    }

    public boolean sendAndReceive(String uri, WebServiceMessageCallback requestCallback, WebServiceMessageCallback responseCallback) {
        Assert.notNull((Object)responseCallback, (String)"responseCallback must not be null");
        Boolean result = (Boolean)this.sendAndReceive(uri, requestCallback, new WebServiceMessageCallbackMessageExtractor(responseCallback));
        return result != null && result != false;
    }

    public Object sendAndReceive(WebServiceMessageCallback requestCallback, WebServiceMessageExtractor responseExtractor) {
        return this.sendAndReceive(this.getDefaultUri(), requestCallback, responseExtractor);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object sendAndReceive(String uriString, WebServiceMessageCallback requestCallback, WebServiceMessageExtractor responseExtractor) {
        Object object;
        Assert.notNull((Object)responseExtractor, (String)"'responseExtractor' must not be null");
        Assert.hasLength((String)uriString, (String)"'uri' must not be empty");
        TransportContext previousTransportContext = TransportContextHolder.getTransportContext();
        WebServiceConnection connection = null;
        try {
            connection = this.createConnection(URI.create(uriString));
            TransportContextHolder.setTransportContext(new DefaultTransportContext(connection));
            DefaultMessageContext messageContext = new DefaultMessageContext(this.getMessageFactory());
            object = this.doSendAndReceive(messageContext, connection, requestCallback, responseExtractor);
        }
        catch (TransportException ex) {
            try {
                throw new WebServiceTransportException("Could not use transport: " + ex.getMessage(), ex);
                catch (IOException ex2) {
                    throw new WebServiceIOException("I/O error: " + ex2.getMessage(), ex2);
                }
            }
            catch (Throwable throwable) {
                TransportUtils.closeConnection(connection);
                TransportContextHolder.setTransportContext(previousTransportContext);
                throw throwable;
            }
        }
        TransportUtils.closeConnection(connection);
        TransportContextHolder.setTransportContext(previousTransportContext);
        return object;
    }

    protected Object doSendAndReceive(MessageContext messageContext, WebServiceConnection connection, WebServiceMessageCallback requestCallback, WebServiceMessageExtractor responseExtractor) throws IOException {
        try {
            if (requestCallback != null) {
                requestCallback.doWithMessage(messageContext.getRequest());
            }
            int interceptorIndex = -1;
            if (this.interceptors != null) {
                for (int i = 0; i < this.interceptors.length; ++i) {
                    interceptorIndex = i;
                    if (!this.interceptors[i].handleRequest(messageContext)) break;
                }
            }
            if (!messageContext.hasResponse()) {
                this.sendRequest(connection, messageContext.getRequest());
                if (this.hasError(connection, messageContext.getRequest())) {
                    return this.handleError(connection, messageContext.getRequest());
                }
                WebServiceMessage response = connection.receive(this.getMessageFactory());
                messageContext.setResponse(response);
            }
            this.logResponse(messageContext);
            if (messageContext.hasResponse()) {
                if (!this.hasFault(connection, messageContext.getResponse())) {
                    this.triggerHandleResponse(interceptorIndex, messageContext);
                    return responseExtractor.extractData(messageContext.getResponse());
                }
                this.triggerHandleFault(interceptorIndex, messageContext);
                return this.handleFault(connection, messageContext);
            }
            return null;
        }
        catch (TransformerException ex) {
            throw new WebServiceTransformerException("Transformation error: " + ex.getMessage(), ex);
        }
    }

    private void sendRequest(WebServiceConnection connection, WebServiceMessage request) throws IOException {
        if (sentMessageTracingLogger.isTraceEnabled()) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            request.writeTo(os);
            sentMessageTracingLogger.trace((Object)("Sent request [" + os.toString("UTF-8") + "]"));
        } else if (sentMessageTracingLogger.isDebugEnabled()) {
            sentMessageTracingLogger.debug((Object)("Sent request [" + request + "]"));
        }
        connection.send(request);
    }

    protected boolean hasError(WebServiceConnection connection, WebServiceMessage request) throws IOException {
        if (this.checkConnectionForError && connection.hasError()) {
            if (this.checkConnectionForFault && connection instanceof FaultAwareWebServiceConnection) {
                FaultAwareWebServiceConnection faultConnection = (FaultAwareWebServiceConnection)connection;
                return !faultConnection.hasFault() || !(request instanceof FaultAwareWebServiceMessage);
            }
            return true;
        }
        return false;
    }

    protected Object handleError(WebServiceConnection connection, WebServiceMessage request) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Received error for request [" + request + "]"));
        }
        throw new WebServiceTransportException(connection.getErrorMessage());
    }

    private void logResponse(MessageContext messageContext) throws IOException {
        if (messageContext.hasResponse()) {
            if (receivedMessageTracingLogger.isTraceEnabled()) {
                ByteArrayOutputStream requestStream = new ByteArrayOutputStream();
                messageContext.getRequest().writeTo(requestStream);
                ByteArrayOutputStream responseStream = new ByteArrayOutputStream();
                messageContext.getResponse().writeTo(responseStream);
                receivedMessageTracingLogger.trace((Object)("Received response [" + responseStream.toString("UTF-8") + "] for request [" + requestStream.toString("UTF-8") + "]"));
            } else if (receivedMessageTracingLogger.isDebugEnabled()) {
                receivedMessageTracingLogger.debug((Object)("Received response [" + messageContext.getResponse() + "] for request [" + messageContext.getRequest() + "]"));
            }
        } else if (this.logger.isDebugEnabled()) {
            receivedMessageTracingLogger.debug((Object)("Received no response for request [" + messageContext.getRequest() + "]"));
        }
    }

    protected boolean hasFault(WebServiceConnection connection, WebServiceMessage response) throws IOException {
        FaultAwareWebServiceConnection faultConnection;
        if (this.checkConnectionForFault && connection instanceof FaultAwareWebServiceConnection && !(faultConnection = (FaultAwareWebServiceConnection)connection).hasFault()) {
            return false;
        }
        if (response instanceof FaultAwareWebServiceMessage) {
            FaultAwareWebServiceMessage faultMessage = (FaultAwareWebServiceMessage)response;
            return faultMessage.hasFault();
        }
        return false;
    }

    private void triggerHandleResponse(int interceptorIndex, MessageContext messageContext) {
        if (messageContext.hasResponse() && this.interceptors != null) {
            for (int i = interceptorIndex; i >= 0 && this.interceptors[i].handleResponse(messageContext); --i) {
            }
        }
    }

    private void triggerHandleFault(int interceptorIndex, MessageContext messageContext) {
        if (messageContext.hasResponse() && this.interceptors != null) {
            for (int i = interceptorIndex; i >= 0 && this.interceptors[i].handleFault(messageContext); --i) {
            }
        }
    }

    protected Object handleFault(WebServiceConnection connection, MessageContext messageContext) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Received Fault message for request [" + messageContext.getRequest() + "]"));
        }
        if (this.getFaultMessageResolver() != null) {
            this.getFaultMessageResolver().resolveFault(messageContext.getResponse());
            return null;
        }
        return this.handleError(connection, messageContext.getRequest());
    }

    private static class SourceExtractorMessageExtractor
    implements WebServiceMessageExtractor {
        private final SourceExtractor sourceExtractor;

        private SourceExtractorMessageExtractor(SourceExtractor sourceExtractor) {
            this.sourceExtractor = sourceExtractor;
        }

        public Object extractData(WebServiceMessage message) throws IOException, TransformerException {
            return this.sourceExtractor.extractData(message.getPayloadSource());
        }
    }

    private static class WebServiceMessageCallbackMessageExtractor
    implements WebServiceMessageExtractor {
        private final WebServiceMessageCallback callback;

        private WebServiceMessageCallbackMessageExtractor(WebServiceMessageCallback callback) {
            this.callback = callback;
        }

        public Object extractData(WebServiceMessage message) throws IOException, TransformerException {
            this.callback.doWithMessage(message);
            return Boolean.TRUE;
        }
    }
}

