/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.axiom;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.ds.ByteArrayDataSource;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPFactory;
import org.springframework.ws.soap.axiom.AxiomSoapBodyException;
import org.springframework.ws.soap.axiom.Payload;
import org.springframework.xml.transform.StaxResult;

class NonCachingPayload
extends Payload {
    private static final int BUF_SIZE = 1024;

    NonCachingPayload(SOAPBody axiomBody, SOAPFactory axiomFactory) {
        super(axiomBody, axiomFactory);
    }

    public Result getResultInternal() {
        return new StaxResult((XMLStreamWriter)new DelegatingStreamWriter());
    }

    protected XMLStreamReader getStreamReader(OMElement payloadElement) {
        return payloadElement.getXMLStreamReaderWithoutCaching();
    }

    private class DelegatingStreamWriter
    implements XMLStreamWriter {
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        private final XMLStreamWriter delegate;
        private QName name;
        private String encoding = "UTF-8";
        private int elementDepth = 0;

        private DelegatingStreamWriter() {
            try {
                this.delegate = StAXUtils.createXMLStreamWriter((OutputStream)this.baos);
            }
            catch (XMLStreamException ex) {
                throw new AxiomSoapBodyException("Could not determine payload root element", ex);
            }
        }

        public void writeStartDocument() throws XMLStreamException {
        }

        public void writeStartDocument(String version) throws XMLStreamException {
        }

        public void writeStartDocument(String encoding, String version) throws XMLStreamException {
            this.encoding = encoding;
        }

        public void writeEndDocument() throws XMLStreamException {
        }

        public void writeStartElement(String localName) throws XMLStreamException {
            if (this.name == null) {
                this.name = new QName(localName);
            }
            ++this.elementDepth;
            this.delegate.writeStartElement(localName);
        }

        public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
            if (this.name == null) {
                this.name = new QName(namespaceURI, localName);
            }
            ++this.elementDepth;
            this.delegate.writeStartElement(namespaceURI, localName);
        }

        public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            if (this.name == null) {
                this.name = new QName(namespaceURI, localName, prefix);
            }
            ++this.elementDepth;
            this.delegate.writeStartElement(prefix, localName, namespaceURI);
        }

        public void writeEndElement() throws XMLStreamException {
            --this.elementDepth;
            this.delegate.writeEndElement();
            if (this.elementDepth <= 0) {
                this.addPayload();
            }
        }

        private void addPayload() throws XMLStreamException {
            this.delegate.flush();
            if (this.baos.size() > 0) {
                byte[] buf = this.baos.toByteArray();
                ByteArrayDataSource dataSource = new ByteArrayDataSource(buf, this.encoding);
                OMNamespace namespace = NonCachingPayload.this.getAxiomFactory().createOMNamespace(this.name.getNamespaceURI(), this.name.getPrefix());
                OMSourcedElement payloadElement = NonCachingPayload.this.getAxiomFactory().createOMElement((OMDataSource)dataSource, this.name.getLocalPart(), namespace);
                NonCachingPayload.this.getAxiomBody().addChild((OMNode)payloadElement);
            }
        }

        public void writeEmptyElement(String localName) throws XMLStreamException {
            if (this.name == null) {
                this.name = new QName(localName);
            }
            this.delegate.writeEmptyElement(localName);
        }

        public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
            if (this.name == null) {
                this.name = new QName(namespaceURI, localName);
            }
            this.delegate.writeEmptyElement(namespaceURI, localName);
        }

        public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            if (this.name == null) {
                this.name = new QName(namespaceURI, localName, prefix);
            }
            this.delegate.writeEmptyElement(prefix, localName, namespaceURI);
        }

        public void close() throws XMLStreamException {
            this.delegate.close();
        }

        public void flush() throws XMLStreamException {
            this.delegate.flush();
        }

        public NamespaceContext getNamespaceContext() {
            return this.delegate.getNamespaceContext();
        }

        public String getPrefix(String uri) throws XMLStreamException {
            return this.delegate.getPrefix(uri);
        }

        public Object getProperty(String name) throws IllegalArgumentException {
            return this.delegate.getProperty(name);
        }

        public void setDefaultNamespace(String uri) throws XMLStreamException {
            this.delegate.setDefaultNamespace(uri);
        }

        public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
            this.delegate.setNamespaceContext(context);
        }

        public void setPrefix(String prefix, String uri) throws XMLStreamException {
            this.delegate.setPrefix(prefix, uri);
        }

        public void writeAttribute(String localName, String value) throws XMLStreamException {
            this.delegate.writeAttribute(localName, value);
        }

        public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
            this.delegate.writeAttribute(namespaceURI, localName, value);
        }

        public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
            this.delegate.writeAttribute(prefix, namespaceURI, localName, value);
        }

        public void writeCData(String data) throws XMLStreamException {
            this.delegate.writeCData(data);
        }

        public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
            this.delegate.writeCharacters(text, start, len);
        }

        public void writeCharacters(String text) throws XMLStreamException {
            this.delegate.writeCharacters(text);
        }

        public void writeComment(String data) throws XMLStreamException {
            this.delegate.writeComment(data);
        }

        public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
            this.delegate.writeDefaultNamespace(namespaceURI);
        }

        public void writeDTD(String dtd) throws XMLStreamException {
            this.delegate.writeDTD(dtd);
        }

        public void writeEntityRef(String name) throws XMLStreamException {
            this.delegate.writeEntityRef(name);
        }

        public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
            this.delegate.writeNamespace(prefix, namespaceURI);
        }

        public void writeProcessingInstruction(String target) throws XMLStreamException {
            this.delegate.writeProcessingInstruction(target);
        }

        public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
            this.delegate.writeProcessingInstruction(target, data);
        }
    }
}

