/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.server.endpoint.interceptor;

import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.interceptor.AbstractValidatingInterceptor;
import org.springframework.ws.soap.SoapBody;
import org.springframework.ws.soap.SoapFault;
import org.springframework.ws.soap.SoapFaultDetail;
import org.springframework.ws.soap.SoapFaultDetailElement;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.xml.namespace.QNameUtils;
import org.xml.sax.SAXParseException;

public abstract class AbstractFaultCreatingValidatingInterceptor
extends AbstractValidatingInterceptor {
    public static final QName DEFAULT_DETAIL_ELEMENT_NAME = QNameUtils.createQName((String)"http://springframework.org/spring-ws", (String)"ValidationError", (String)"spring-ws");
    public static final String DEFAULT_FAULTSTRING_OR_REASON = "Validation error";
    private boolean addValidationErrorDetail = true;
    private QName detailElementName = DEFAULT_DETAIL_ELEMENT_NAME;
    private String faultStringOrReason = "Validation error";
    private Locale faultStringOrReasonLocale = Locale.ENGLISH;

    public boolean getAddValidationErrorDetail() {
        return this.addValidationErrorDetail;
    }

    public void setAddValidationErrorDetail(boolean addValidationErrorDetail) {
        this.addValidationErrorDetail = addValidationErrorDetail;
    }

    public QName getDetailElementName() {
        return this.detailElementName;
    }

    public void setDetailElementName(QName detailElementName) {
        this.detailElementName = detailElementName;
    }

    public String getFaultStringOrReason() {
        return this.faultStringOrReason;
    }

    public void setFaultStringOrReason(String faultStringOrReason) {
        this.faultStringOrReason = faultStringOrReason;
    }

    public Locale getFaultStringOrReasonLocale() {
        return this.faultStringOrReasonLocale;
    }

    public void setFaultStringOrReasonLocale(Locale faultStringOrReasonLocale) {
        this.faultStringOrReasonLocale = faultStringOrReasonLocale;
    }

    protected boolean handleRequestValidationErrors(MessageContext messageContext, SAXParseException[] errors) throws TransformerException {
        for (int i = 0; i < errors.length; ++i) {
            this.logger.warn((Object)("XML validation error on request: " + errors[i].getMessage()));
        }
        if (messageContext.getResponse() instanceof SoapMessage) {
            SoapMessage response = (SoapMessage)messageContext.getResponse();
            SoapBody body = response.getSoapBody();
            SoapFault fault = body.addClientOrSenderFault(this.getFaultStringOrReason(), this.getFaultStringOrReasonLocale());
            if (this.getAddValidationErrorDetail()) {
                SoapFaultDetail detail = fault.addFaultDetail();
                for (int i = 0; i < errors.length; ++i) {
                    SoapFaultDetailElement detailElement = detail.addFaultDetailElement(this.getDetailElementName());
                    detailElement.addText(errors[i].getMessage());
                }
            }
        }
        return false;
    }
}

