/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.wsdl.wsdl11.provider;

import java.util.Iterator;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.ws.wsdl.wsdl11.provider.BindingsProvider;
import org.springframework.ws.wsdl.wsdl11.provider.ServicesProvider;

public class DefaultConcretePartProvider
implements BindingsProvider,
ServicesProvider {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String bindingSuffix;
    private String serviceName;

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        Assert.hasText((String)serviceName, (String)"'serviceName' must not be null");
        this.serviceName = serviceName;
    }

    public String getBindingSuffix() {
        return this.bindingSuffix;
    }

    public void setBindingSuffix(String bindingSuffix) {
        Assert.hasText((String)bindingSuffix, (String)"'bindingSuffix' must not be null");
        this.bindingSuffix = bindingSuffix;
    }

    public void addBindings(Definition definition) throws WSDLException {
        Iterator iterator = definition.getPortTypes().values().iterator();
        while (iterator.hasNext()) {
            PortType portType = (PortType)iterator.next();
            Binding binding = definition.createBinding();
            binding.setPortType(portType);
            this.populateBinding(definition, binding);
            this.createBindingOperations(definition, binding);
            binding.setUndefined(false);
            if (binding.getQName() == null) continue;
            definition.addBinding(binding);
        }
        if (definition.getBindings().isEmpty() && this.logger.isWarnEnabled()) {
            this.logger.warn((Object)"No bindings were created, make sure the WSDL contains port types");
        }
    }

    protected void populateBinding(Definition definition, Binding binding) throws WSDLException {
        QName portTypeName = binding.getPortType().getQName();
        if (portTypeName != null) {
            QName bindingName = new QName(portTypeName.getNamespaceURI(), portTypeName.getLocalPart() + this.getBindingSuffix());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Creating binding [" + bindingName + "]"));
            }
            binding.setQName(bindingName);
        }
    }

    private void createBindingOperations(Definition definition, Binding binding) throws WSDLException {
        PortType portType = binding.getPortType();
        Iterator operationIterator = portType.getOperations().iterator();
        while (operationIterator.hasNext()) {
            Operation operation = (Operation)operationIterator.next();
            BindingOperation bindingOperation = definition.createBindingOperation();
            bindingOperation.setOperation(operation);
            this.populateBindingOperation(definition, bindingOperation);
            if (OperationType.REQUEST_RESPONSE.equals(operation.getStyle())) {
                this.createBindingInput(definition, operation, bindingOperation);
                this.createBindingOutput(definition, operation, bindingOperation);
            } else if (OperationType.ONE_WAY.equals(operation.getStyle())) {
                this.createBindingInput(definition, operation, bindingOperation);
            } else if (OperationType.NOTIFICATION.equals(operation.getStyle())) {
                this.createBindingOutput(definition, operation, bindingOperation);
            } else if (OperationType.SOLICIT_RESPONSE.equals(operation.getStyle())) {
                this.createBindingOutput(definition, operation, bindingOperation);
                this.createBindingInput(definition, operation, bindingOperation);
            }
            Iterator faultIterator = operation.getFaults().values().iterator();
            while (faultIterator.hasNext()) {
                Fault fault = (Fault)faultIterator.next();
                BindingFault bindingFault = definition.createBindingFault();
                this.populateBindingFault(definition, bindingFault, fault);
                if (!StringUtils.hasText((String)bindingFault.getName())) continue;
                bindingOperation.addBindingFault(bindingFault);
            }
            binding.addBindingOperation(bindingOperation);
        }
    }

    protected void populateBindingOperation(Definition definition, BindingOperation bindingOperation) throws WSDLException {
        bindingOperation.setName(bindingOperation.getOperation().getName());
    }

    private void createBindingInput(Definition definition, Operation operation, BindingOperation bindingOperation) throws WSDLException {
        BindingInput bindingInput = definition.createBindingInput();
        this.populateBindingInput(definition, bindingInput, operation.getInput());
        bindingOperation.setBindingInput(bindingInput);
    }

    private void createBindingOutput(Definition definition, Operation operation, BindingOperation bindingOperation) throws WSDLException {
        BindingOutput bindingOutput = definition.createBindingOutput();
        this.populateBindingOutput(definition, bindingOutput, operation.getOutput());
        bindingOperation.setBindingOutput(bindingOutput);
    }

    protected void populateBindingInput(Definition definition, BindingInput bindingInput, Input input) throws WSDLException {
        bindingInput.setName(input.getName());
    }

    protected void populateBindingOutput(Definition definition, BindingOutput bindingOutput, Output output) throws WSDLException {
        bindingOutput.setName(output.getName());
    }

    protected void populateBindingFault(Definition definition, BindingFault bindingFault, Fault fault) throws WSDLException {
        bindingFault.setName(fault.getName());
    }

    public void addServices(Definition definition) throws WSDLException {
        Assert.notNull((Object)this.getServiceName(), (String)"'serviceName' is required");
        Service service = definition.getServices().isEmpty() ? definition.createService() : (Service)definition.getServices().values().iterator().next();
        this.populateService(definition, service);
        this.createPorts(definition, service);
        if (service.getQName() != null) {
            definition.addService(service);
        }
    }

    protected void populateService(Definition definition, Service service) throws WSDLException {
        if (StringUtils.hasText((String)definition.getTargetNamespace()) && StringUtils.hasText((String)this.getServiceName())) {
            QName serviceName = new QName(definition.getTargetNamespace(), this.getServiceName());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Creating service [" + serviceName + "]"));
            }
            service.setQName(serviceName);
        }
    }

    private void createPorts(Definition definition, Service service) throws WSDLException {
        Iterator iterator = definition.getBindings().values().iterator();
        while (iterator.hasNext()) {
            Binding binding = (Binding)iterator.next();
            Port port = null;
            Iterator iterator1 = service.getPorts().values().iterator();
            while (iterator1.hasNext()) {
                Port existingPort = (Port)iterator1.next();
                if (!binding.equals(existingPort.getBinding())) continue;
                port = existingPort;
            }
            if (port == null) {
                port = definition.createPort();
                port.setBinding(binding);
            }
            this.populatePort(definition, port);
            if (!StringUtils.hasText((String)port.getName())) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Adding port [" + port.getName() + "] to service [" + service.getQName() + "]"));
            }
            service.addPort(port);
        }
        if (service.getPorts().isEmpty() && this.logger.isWarnEnabled()) {
            this.logger.warn((Object)"No ports were created, make sure the WSDL contains bindings");
        }
    }

    protected void populatePort(Definition definition, Port port) throws WSDLException {
        String portName = port.getBinding().getQName().getLocalPart();
        port.setName(portName);
    }
}

