/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.wsdl.wsdl11.provider;

import java.util.Iterator;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.ws.wsdl.wsdl11.provider.MessagesProvider;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultMessagesProvider
implements MessagesProvider {
    private static final Log logger = LogFactory.getLog((Class)DefaultMessagesProvider.class);

    public void addMessages(Definition definition) throws WSDLException {
        Types types = definition.getTypes();
        Assert.notNull((Object)types, (String)"No types element present in definition");
        Iterator iterator = types.getExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            Schema schema;
            ExtensibilityElement extensibilityElement = (ExtensibilityElement)iterator.next();
            if (!(extensibilityElement instanceof Schema) || (schema = (Schema)extensibilityElement).getElement() == null) continue;
            this.createMessages(definition, schema.getElement());
        }
        if (definition.getMessages().isEmpty() && logger.isWarnEnabled()) {
            logger.warn((Object)"No messages were created, make sure the referenced schema(s) contain elements");
        }
    }

    private void createMessages(Definition definition, Element schemaElement) throws WSDLException {
        String schemaTargetNamespace = schemaElement.getAttribute("targetNamespace");
        Assert.hasText((String)schemaTargetNamespace, (String)"No targetNamespace defined on schema");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Looking for elements in schema with target namespace [" + schemaTargetNamespace + "]"));
        }
        NodeList children = schemaElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element childElement;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !this.isMessageElement(childElement = (Element)child)) continue;
            QName elementName = new QName(schemaTargetNamespace, this.getElementName(childElement));
            Message message = definition.createMessage();
            this.populateMessage(definition, message, elementName);
            Part part = definition.createPart();
            this.populatePart(definition, part, elementName);
            message.addPart(part);
            message.setUndefined(false);
            definition.addMessage(message);
        }
    }

    protected String getElementName(Element element) {
        return element.getAttribute("name");
    }

    protected boolean isMessageElement(Element element) {
        return "element".equals(element.getLocalName()) && "http://www.w3.org/2001/XMLSchema".equals(element.getNamespaceURI());
    }

    protected void populateMessage(Definition definition, Message message, QName elementName) throws WSDLException {
        QName messageName = new QName(definition.getTargetNamespace(), elementName.getLocalPart());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating message [" + messageName + "]"));
        }
        message.setQName(messageName);
    }

    protected void populatePart(Definition definition, Part part, QName elementName) throws WSDLException {
        part.setElementName(elementName);
        part.setName(elementName.getLocalPart());
    }
}

