/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.core.Config;
import org.springframework.web.servlet.support.RequestContext;

public class JspAwareRequestContext
extends RequestContext {
    private PageContext pageContext;

    public JspAwareRequestContext(PageContext pageContext) {
        this.initContext(pageContext, null);
    }

    public JspAwareRequestContext(PageContext pageContext, Map model) {
        this.initContext(pageContext, model);
    }

    protected void initContext(PageContext pageContext, Map model) {
        if (!(pageContext.getRequest() instanceof HttpServletRequest)) {
            throw new IllegalArgumentException("RequestContext only supports HTTP requests");
        }
        this.pageContext = pageContext;
        this.initContext((HttpServletRequest)pageContext.getRequest(), pageContext.getServletContext(), model);
    }

    protected final PageContext getPageContext() {
        return this.pageContext;
    }

    protected Locale getFallbackLocale() {
        Locale locale;
        if (jstlPresent && (locale = JstlPageLocaleResolver.getJstlLocale(this.getPageContext())) != null) {
            return locale;
        }
        return this.getRequest().getLocale();
    }

    private static class JstlPageLocaleResolver {
        private JstlPageLocaleResolver() {
        }

        public static Locale getJstlLocale(PageContext pageContext) {
            Object localeObject = Config.find((PageContext)pageContext, (String)"javax.servlet.jsp.jstl.fmt.locale");
            return localeObject instanceof Locale ? (Locale)localeObject : null;
        }
    }
}

