/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.xfire.AbstractContext;
import org.codehaus.xfire.service.FaultInfo;
import org.codehaus.xfire.service.MessageInfo;
import org.codehaus.xfire.service.ServiceInfo;
import org.codehaus.xfire.service.Visitable;
import org.codehaus.xfire.service.Visitor;

public class OperationInfo
extends AbstractContext
implements Visitable {
    private String name;
    private ServiceInfo service;
    private String mep;
    private boolean async;
    private MessageInfo inputMessage;
    private MessageInfo outputMessage;
    private Map faults = new HashMap();
    private Method method;

    OperationInfo(String name, Method method, ServiceInfo service) {
        this.name = name;
        this.service = service;
        this.method = method;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Invalid name [" + name + "]");
        }
        this.service.removeOperation(this.name);
        this.name = name;
        this.service.addOperation(this);
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public String getMEP() {
        return this.mep;
    }

    public void setMEP(String mep) {
        this.mep = mep;
    }

    public ServiceInfo getService() {
        return this.service;
    }

    public MessageInfo createMessage(QName name) {
        MessageInfo message = new MessageInfo(name, this);
        return message;
    }

    public MessageInfo getInputMessage() {
        return this.inputMessage;
    }

    public void setInputMessage(MessageInfo inputMessage) {
        this.inputMessage = inputMessage;
    }

    public MessageInfo getOutputMessage() {
        return this.outputMessage;
    }

    public void setOutputMessage(MessageInfo outputMessage) {
        this.outputMessage = outputMessage;
    }

    public FaultInfo addFault(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Invalid name [" + name + "]");
        }
        if (this.faults.containsKey(name)) {
            throw new IllegalArgumentException("A fault with name [" + name + "] already exists in this operation");
        }
        FaultInfo fault = new FaultInfo(name, this);
        this.addFault(fault);
        return fault;
    }

    void addFault(FaultInfo fault) {
        this.faults.put(fault.getName(), fault);
    }

    public void removeFault(String name) {
        this.faults.remove(name);
    }

    public FaultInfo getFault(String name) {
        return (FaultInfo)this.faults.get(name);
    }

    public Collection getFaults() {
        return Collections.unmodifiableCollection(this.faults.values());
    }

    public void accept(Visitor visitor) {
        visitor.startOperation(this);
        if (this.inputMessage != null) {
            this.inputMessage.accept(visitor);
        }
        if (this.outputMessage != null) {
            this.outputMessage.accept(visitor);
        }
        Iterator iterator = this.faults.values().iterator();
        while (iterator.hasNext()) {
            FaultInfo faultInfo = (FaultInfo)iterator.next();
            faultInfo.accept(visitor);
        }
        visitor.endOperation(this);
    }

    public boolean hasOutput() {
        return this.outputMessage != null;
    }

    public boolean hasInput() {
        return this.inputMessage != null;
    }
}

