/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service.invoker;

import java.lang.reflect.Modifier;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.util.factory.Factory;

final class LocalFactory
implements Factory {
    private final ThreadLocal local = new ThreadLocal();
    private final String service_class_key;

    public Service getService() {
        return (Service)this.local.get();
    }

    public void setService(Service service) {
        this.local.set(service);
    }

    public Object create() throws XFireFault {
        Service service = this.getService();
        if (service == null) {
            throw new XFireFault("service not initialized yet!", XFireFault.RECEIVER);
        }
        try {
            Class svcClass = (Class)service.getProperty(this.service_class_key);
            if (svcClass == null && (svcClass = service.getServiceInfo().getServiceClass()).isInterface()) {
                throw new XFireFault(this.service_class_key + " not set for interface '" + svcClass.getName() + "'", XFireFault.RECEIVER);
            }
            if (svcClass.isInterface()) {
                throw new XFireFault("Service class '" + svcClass.getName() + "' is an interface", XFireFault.RECEIVER);
            }
            if (Modifier.isAbstract(svcClass.getModifiers())) {
                throw new XFireFault("Service class '" + svcClass.getName() + "' is abstract", XFireFault.RECEIVER);
            }
            return svcClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new XFireFault("Couldn't instantiate service object.", e, XFireFault.RECEIVER);
        }
        catch (IllegalAccessException e) {
            throw new XFireFault("Couldn't access service object.", e, XFireFault.RECEIVER);
        }
    }

    public LocalFactory(String service_class_key) {
        this.service_class_key = service_class_key;
    }

    public LocalFactory(String service_class_key, Service service) {
        this.service_class_key = service_class_key;
        this.setService(service);
    }
}

