/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.attachments.Attachments;
import org.codehaus.xfire.attachments.JavaMailAttachments;
import org.codehaus.xfire.attachments.SimpleAttachment;
import org.codehaus.xfire.attachments.StreamedAttachments;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.transport.http.AbstractMessageSender;
import org.codehaus.xfire.transport.http.HttpChannel;
import org.codehaus.xfire.transport.http.OutMessageRequestEntity;
import org.codehaus.xfire.util.OutMessageDataSource;
import org.codehaus.xfire.util.STAXUtils;

public class CommonsHttpMessageSender
extends AbstractMessageSender {
    private PostMethod postMethod;
    private HttpClient client;
    private HttpState state;
    public static final String HTTP_CLIENT_PARAMS = "httpClient.params";
    public static final String USER_AGENT = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0; XFire Client +http://xfire.codehaus.org)";
    public static final String HTTP_PROXY_HOST = "http.proxyHost";
    public static final String HTTP_PROXY_PORT = "http.proxyPort";
    public static final String HTTP_STATE = "httpClient.httpstate";
    public static final String HTTP_CLIENT = "httpClient";
    private InputStream msgIs;

    public CommonsHttpMessageSender(OutMessage message, MessageContext context) {
        super(message, context);
    }

    public void open() throws IOException, XFireException {
        MessageContext context = this.getMessageContext();
        this.client = (HttpClient)((HttpChannel)this.getMessage().getChannel()).getProperty(HTTP_CLIENT);
        if (this.client == null) {
            this.client = new HttpClient();
            this.client.setHttpConnectionManager((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
            ((HttpChannel)this.getMessage().getChannel()).setProperty(HTTP_CLIENT, this.client);
            HttpClientParams params = (HttpClientParams)context.getContextualProperty(HTTP_CLIENT_PARAMS);
            if (params == null) {
                params = this.client.getParams();
                this.client.getParams().setParameter("http.useragent", (Object)USER_AGENT);
                this.client.getParams().setBooleanParameter("http.protocol.expect-continue", true);
                this.client.getParams().setVersion(HttpVersion.HTTP_1_1);
            } else {
                this.client.setParams(params);
            }
            String proxyHost = (String)context.getContextualProperty(HTTP_PROXY_HOST);
            if (proxyHost != null) {
                String portS = (String)context.getContextualProperty(HTTP_PROXY_PORT);
                int port = 80;
                if (portS != null) {
                    port = Integer.parseInt(portS);
                }
                this.client.getHostConfiguration().setProxy(proxyHost, port);
            }
        }
        this.state = this.getHttpState();
        this.postMethod = new PostMethod(this.getUri());
        String username = (String)context.getContextualProperty("username");
        if (username != null) {
            String password = (String)context.getContextualProperty("password");
            this.client.getParams().setAuthenticationPreemptive(true);
            this.state.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        }
        if (this.getSoapAction() != null) {
            this.postMethod.setRequestHeader("SOAPAction", this.getQuotedSoapAction());
        }
        OutMessage message = this.getMessage();
        boolean mtomEnabled = Boolean.valueOf((String)context.getContextualProperty("mtom-enabled"));
        Attachments atts = message.getAttachments();
        if (mtomEnabled || atts != null) {
            if (atts == null) {
                atts = new JavaMailAttachments();
                message.setAttachments(atts);
            }
            OutMessageDataSource source = new OutMessageDataSource(context, message);
            DataHandler soapHandler = new DataHandler((DataSource)source);
            atts.setSoapContentType(HttpChannel.getSoapMimeType(message, false));
            atts.setSoapMessage(new SimpleAttachment(source.getName(), soapHandler));
            this.postMethod.setRequestHeader("Content-Type", atts.getContentType());
        } else {
            this.postMethod.setRequestHeader("Content-Type", HttpChannel.getSoapMimeType(this.getMessage(), true));
        }
    }

    public void send() throws HttpException, IOException, XFireException {
        boolean chunkingOn = Boolean.valueOf((String)this.getMessageContext().getContextualProperty("urn:xfire:transport:http:chunking-enabled"));
        Object requestEntity = !chunkingOn ? this.getByteArrayRequestEntity() : new OutMessageRequestEntity(this.getMessage(), this.getMessageContext());
        this.getMethod().setRequestEntity(requestEntity);
        this.client.executeMethod(null, (HttpMethod)this.postMethod, this.state);
    }

    public boolean hasResponse() {
        String ct = this.postMethod.getResponseHeader("Content-Type").getValue();
        return ct != null && ct.length() > 0;
    }

    public HttpState getHttpState() {
        HttpState state = (HttpState)((HttpChannel)this.getMessage().getChannel()).getProperty(HTTP_STATE);
        if (state == null) {
            state = new HttpState();
            ((HttpChannel)this.getMessage().getChannel()).setProperty(HTTP_STATE, state);
        }
        return state;
    }

    private RequestEntity getByteArrayRequestEntity() throws IOException, XFireException {
        OutMessage message = this.getMessage();
        MessageContext context = this.getMessageContext();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Attachments atts = message.getAttachments();
        if (atts != null) {
            atts.write(bos);
        } else {
            HttpChannel.writeWithoutAttachments(context, message, bos);
        }
        return new ByteArrayRequestEntity(bos.toByteArray());
    }

    public InMessage getInMessage() throws IOException {
        String ct = this.postMethod.getResponseHeader("Content-Type").getValue();
        InputStream in = this.postMethod.getResponseBodyAsStream();
        if (ct.toLowerCase().indexOf("multipart/related") != -1) {
            StreamedAttachments atts = new StreamedAttachments(in, ct);
            this.msgIs = atts.getSoapMessage().getDataHandler().getInputStream();
            InMessage msg = new InMessage(STAXUtils.createXMLStreamReader(this.msgIs, this.getEncoding(), this.getMessageContext()), this.getUri());
            msg.setAttachments(atts);
            return msg;
        }
        return new InMessage(STAXUtils.createXMLStreamReader(in, this.getEncoding(), this.getMessageContext()), this.getUri());
    }

    public PostMethod getMethod() {
        return this.postMethod;
    }

    public void close() throws XFireException {
        if (this.msgIs != null) {
            try {
                this.msgIs.close();
            }
            catch (IOException e) {
                throw new XFireException("Could not close connection.", e);
            }
        }
        if (this.postMethod != null) {
            this.postMethod.releaseConnection();
        }
    }
}

