/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.transport.http.AbstractMessageSender;
import org.codehaus.xfire.util.STAXUtils;

public class SimpleMessageSender
extends AbstractMessageSender {
    private HttpURLConnection urlConn;
    private InputStream is;

    public SimpleMessageSender(OutMessage message, MessageContext context) {
        super(message, context);
    }

    public void open() throws IOException, XFireFault {
        URL url = new URL(this.getUri());
        this.urlConn = this.createConnection(url);
        this.urlConn.setDoInput(true);
        this.urlConn.setDoOutput(true);
        this.urlConn.setUseCaches(false);
        this.urlConn.setRequestMethod("POST");
        this.urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        this.urlConn.setRequestProperty("User-Agent", "XFire Client +http://xfire.codehaus.org");
        this.urlConn.setRequestProperty("Accept", "text/xml; text/html");
        this.urlConn.setRequestProperty("Content-type", "text/xml; charset=" + this.getEncoding());
        this.urlConn.setRequestProperty("SOAPAction", this.getQuotedSoapAction());
    }

    public OutputStream getOutputStream() throws IOException, XFireFault {
        return this.urlConn.getOutputStream();
    }

    public InMessage getInMessage() throws IOException {
        block2: {
            try {
                this.is = this.urlConn.getInputStream();
            }
            catch (IOException ioe) {
                if (this.urlConn.getResponseCode() != 500) break block2;
                this.is = this.urlConn.getErrorStream();
            }
        }
        return new InMessage(STAXUtils.createXMLStreamReader(this.is, this.getEncoding(), this.getMessageContext()), this.getUri());
    }

    public void close() throws XFireException {
        try {
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (IOException e) {
            throw new XFireException("Couldn't close stream.", e);
        }
        finally {
            if (this.urlConn != null) {
                this.urlConn.disconnect();
            }
        }
    }

    private HttpURLConnection createConnection(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }

    public boolean hasResponse() {
        return true;
    }

    public void send() throws IOException, XFireFault {
        OutputStream out = this.getOutputStream();
        OutMessage message = this.getMessage();
        XMLStreamWriter writer = STAXUtils.createXMLStreamWriter(out, message.getEncoding(), null);
        message.getSerializer().writeMessage(message, writer, this.getMessageContext());
        out.flush();
        out.close();
    }
}

