/*
 * Decompiled with CFR 0.152.
 */
package com.dsjdf.db.pool;

import com.dsjdf.db.pool.ConnMgrException;
import com.dsjdf.db.pool.JdbcConnSpec;
import com.dsjdf.db.pool.PoolConnection;
import com.dsjdf.jdf.Configuration;
import com.dsjdf.jdf.Logger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class ConnMgr
extends Thread {
    private Object lock = this;
    private Hashtable poolList = new Hashtable();
    private static final int MIN_POOL_SIZE = 3;
    private static final int MAX_POOL_SIZE = 30;
    private static final int CHECK_TIME_INTERVAL = 60000;

    public ConnMgr() {
        Thread poolObserver = new Thread(this);
        poolObserver.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolConnection getPoolConnection(JdbcConnSpec spec) throws ConnMgrException {
        PoolConnection poolConn = null;
        Object object = this.lock;
        synchronized (object) {
            Vector pool = null;
            Enumeration list = this.poolList.keys();
            while (list.hasMoreElements()) {
                JdbcConnSpec s = (JdbcConnSpec)list.nextElement();
                if (!s.equals(spec)) continue;
                pool = (Vector)this.poolList.get(s);
                break;
            }
            if (pool == null) {
                Vector p = new Vector();
                this.poolList.put(spec, p);
                pool = p;
            }
            int poolsize = pool.size();
            int i = poolsize - 1;
            while (i >= 0) {
                PoolConnection p = (PoolConnection)pool.elementAt(i);
                if (!p.isUsed()) {
                    poolConn = p;
                    break;
                }
                --i;
            }
            if (poolConn == null) {
                int poolMaxSize = 30;
                try {
                    Configuration conf = new Configuration();
                    poolMaxSize = conf.getInt("db.pool.size.max");
                }
                catch (Exception e) {
                    throw new ConnMgrException("check configuration file : " + e.getMessage());
                }
                if (poolsize >= poolMaxSize) {
                    throw new ConnMgrException("maximum number of connection pool size (" + poolMaxSize + ") exceeded");
                }
                Properties prop = spec.getProperties();
                try {
                    Class.forName((String)prop.get("driver"));
                }
                catch (ClassNotFoundException e) {
                    throw new ConnMgrException("JDF: " + e.getMessage());
                }
                Connection conn = null;
                try {
                    String url = (String)prop.get("url");
                    conn = DriverManager.getConnection(url, prop);
                }
                catch (SQLException e) {
                    throw new ConnMgrException(e.getMessage());
                }
                poolConn = new PoolConnection(conn, this.lock);
                pool.addElement(poolConn);
            }
            poolConn.setInUsed();
        }
        return poolConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            boolean trace = false;
            int time = 60000;
            int poolMinSize = 3;
            int poolMaxSize = 30;
            try {
                Configuration conf = new Configuration();
                trace = conf.getBoolean("db.pool.trace");
                time = conf.getInt("db.pool.checkinterval");
                poolMinSize = conf.getInt("db.pool.size.min");
                poolMaxSize = conf.getInt("db.pool.size.max");
            }
            catch (Exception e) {
                Logger.sys.println(this, "ConnMgr.run(): Check configuration file : " + e.getMessage());
            }
            try {
                Thread.sleep(time);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Object object = this.lock;
            synchronized (object) {
                Hashtable poolListClone = (Hashtable)this.poolList.clone();
                Enumeration list = poolListClone.keys();
                while (list.hasMoreElements()) {
                    JdbcConnSpec s = (JdbcConnSpec)list.nextElement();
                    Vector pool = (Vector)this.poolList.get(s);
                    Vector poolClone = (Vector)pool.clone();
                    int availablePoolCount = 0;
                    int poolsize = poolClone.size();
                    int i = poolsize - 1;
                    while (i >= 0) {
                        PoolConnection p = (PoolConnection)poolClone.elementAt(i);
                        if (!p.isUsed()) {
                            Connection conn = p.getConnection();
                            boolean isClosed = true;
                            try {
                                if (conn != null) {
                                    isClosed = conn.isClosed();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (isClosed || availablePoolCount >= poolMinSize) {
                                p.close();
                                pool.removeElement(p);
                            } else {
                                ++availablePoolCount;
                            }
                        }
                        --i;
                    }
                    if (pool.size() == 0) {
                        this.poolList.remove(s);
                    }
                    if (!trace && pool.size() <= poolMinSize) continue;
                    Logger.sys.println(this, "[JDF Connection Pool:" + this.hashCode() + "]" + s.getProperties().toString() + ": interval=" + time + ", min=" + poolMinSize + ", max=" + poolMaxSize + ", current=" + pool.size());
                }
            }
        }
    }
}

