/*
 * Decompiled with CFR 0.152.
 */
package com.dsjdf.jdf;

import com.dsjdf.jdf.ConfigurationException;
import com.dsjdf.jdf.GeneralConfiguration;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class Configuration
extends GeneralConfiguration {
    private static long jdf_last_modified = 0L;
    private static long pbf_last_modified = 0L;
    private static String jdf_file_name = null;

    static {
        File default_file = new File(System.getProperty("user.home"), "dsjdf.properties");
        jdf_file_name = System.getProperty("com.dsjdf.config.file", default_file.getAbsolutePath());
    }

    public Configuration() throws ConfigurationException {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() throws ConfigurationException {
        Object object = lock;
        synchronized (object) {
            try {
                boolean needUpdate = false;
                File jdf_file = new File(jdf_file_name);
                if (!jdf_file.canRead()) {
                    throw new ConfigurationException(String.valueOf(this.getClass().getName()) + " - Can't open dsjdf configuration file: " + jdf_file_name);
                }
                if (jdf_last_modified != jdf_file.lastModified() || props == null) {
                    needUpdate = true;
                } else {
                    String pbf_file_name = props.getProperty("pbf.propertiesFile");
                    if (pbf_file_name != null) {
                        File pbf_file = new File(pbf_file_name = pbf_file_name.trim());
                        if (pbf_file.canRead()) {
                            if (pbf_last_modified != pbf_file.lastModified()) {
                                needUpdate = true;
                            }
                        } else {
                            pbf_file_name = null;
                        }
                    }
                }
                if (needUpdate) {
                    props = new Properties();
                    FileInputStream jdf_fin = new FileInputStream(jdf_file);
                    props.load(new BufferedInputStream(jdf_fin));
                    jdf_fin.close();
                    jdf_last_modified = jdf_file.lastModified();
                    String pbf_file_name = props.getProperty("pbf.propertiesFile");
                    if (pbf_file_name != null) {
                        File pbf_file = new File(pbf_file_name);
                        if (!pbf_file.canRead()) {
                            pbf_file = null;
                        } else {
                            FileInputStream pbf_fin = new FileInputStream(pbf_file);
                            props.load(new BufferedInputStream(pbf_fin));
                            pbf_fin.close();
                            pbf_last_modified = pbf_file.lastModified();
                        }
                    }
                    GeneralConfiguration.lastModified = System.currentTimeMillis();
                }
            }
            catch (ConfigurationException e) {
                GeneralConfiguration.lastModified = 0L;
                jdf_last_modified = 0L;
                pbf_last_modified = 0L;
                throw e;
            }
            catch (Exception e) {
                GeneralConfiguration.lastModified = 0L;
                jdf_last_modified = 0L;
                pbf_last_modified = 0L;
                throw new ConfigurationException(String.valueOf(this.getClass().getName()) + " - Can't load configuration file: " + e.getMessage());
            }
        }
    }
}

