/*
 * Decompiled with CFR 0.152.
 */
package com.dsjdf.jdf;

import com.dsjdf.jdf.Configuration;
import com.dsjdf.jdf.GeneralMessageStore;
import com.dsjdf.jdf.MessageException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class MessageStore
extends GeneralMessageStore {
    private static long last_modified = 0L;

    public MessageStore() throws MessageException {
    }

    public MessageStore(String code) throws MessageException {
        super(code);
    }

    protected void initialize() throws MessageException {
        try {
            Configuration conf = new Configuration();
            File file = new File(conf.get("message.file").trim());
            if (!file.canRead()) {
                throw new MessageException(" Can't read Message Definition File: " + file.getAbsolutePath());
            }
            if (last_modified == file.lastModified()) {
                return;
            }
            messages = new Properties();
            FileInputStream fin = new FileInputStream(file);
            messages.load(new BufferedInputStream(fin));
            fin.close();
            last_modified = file.lastModified();
        }
        catch (MessageException e) {
            messages = null;
            last_modified = 0L;
            throw e;
        }
        catch (Exception e) {
            messages = null;
            last_modified = 0L;
            throw new MessageException("Can't read Message Definition File:  " + e.getMessage());
        }
    }
}

